/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.openservices.ots.model.ConsumedCapacity;
import com.aliyun.openservices.ots.model.Error;
import com.aliyun.openservices.ots.model.OTSResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchWriteRowResult
extends OTSResult {
    private Map<String, List<RowStatus>> tableToPutRowStatus = new HashMap<String, List<RowStatus>>();
    private Map<String, List<RowStatus>> tableToUpdateRowStatus = new HashMap<String, List<RowStatus>>();
    private Map<String, List<RowStatus>> tableToDeleteRowStatus = new HashMap<String, List<RowStatus>>();

    BatchWriteRowResult(OTSResult meta) {
        super(meta);
    }

    void addPutRowResult(String tableName, RowStatus status) {
        this.addResult(tableName, status, this.tableToPutRowStatus);
    }

    void addUpdateRowResult(String tableName, RowStatus status) {
        this.addResult(tableName, status, this.tableToUpdateRowStatus);
    }

    void addDeleteRowResult(String tableName, RowStatus status) {
        this.addResult(tableName, status, this.tableToDeleteRowStatus);
    }

    private void addResult(String tableName, RowStatus status, Map<String, List<RowStatus>> tableToRowStatus) {
        List<RowStatus> statuses = tableToRowStatus.get(tableName);
        if (statuses == null) {
            statuses = new ArrayList<RowStatus>();
            tableToRowStatus.put(tableName, statuses);
        }
        statuses.add(status);
    }

    public List<RowStatus> getPutRowStatus(String tableName) {
        return this.tableToPutRowStatus.get(tableName);
    }

    public Map<String, List<RowStatus>> getPutRowStatus() {
        return this.tableToPutRowStatus;
    }

    public List<RowStatus> getUpdateRowStatus(String tableName) {
        return this.tableToUpdateRowStatus.get(tableName);
    }

    public Map<String, List<RowStatus>> getUpdateRowStatus() {
        return this.tableToUpdateRowStatus;
    }

    public List<RowStatus> getDeleteRowStatus(String tableName) {
        return this.tableToDeleteRowStatus.get(tableName);
    }

    public Map<String, List<RowStatus>> getDeleteRowStatus() {
        return this.tableToDeleteRowStatus;
    }

    public static class RowStatus {
        private boolean isSucceed = false;
        private Error error;
        private ConsumedCapacity consumedCapacity;

        public RowStatus(ConsumedCapacity consumedCapacity) {
            this.isSucceed = true;
            this.consumedCapacity = consumedCapacity;
        }

        public RowStatus(Error error) {
            this.isSucceed = false;
            this.error = error;
        }

        public boolean isSucceed() {
            return this.isSucceed;
        }

        public Error getError() {
            return this.error;
        }

        public ConsumedCapacity getConsumedCapacity() {
            return this.consumedCapacity;
        }
    }
}

