/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.common.utils.CodingUtils;
import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.model.ColumnType;

public class ColumnValue {
    private ColumnType type;
    private Object value;

    private ColumnValue(Object value, ColumnType type) {
        CodingUtils.assertParameterNotNull(value, "value");
        CodingUtils.assertParameterNotNull((Object)type, "type");
        this.value = value;
        this.type = type;
    }

    public ColumnType getType() {
        return this.type;
    }

    public static ColumnValue fromLong(long value) {
        return new ColumnValue(value, ColumnType.INTEGER);
    }

    public static ColumnValue fromBoolean(boolean value) {
        return new ColumnValue(value, ColumnType.BOOLEAN);
    }

    public static ColumnValue fromDouble(double value) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("DoubleNaNNotSupported"));
        }
        return new ColumnValue(value, ColumnType.DOUBLE);
    }

    public static ColumnValue fromBinary(byte[] value) {
        CodingUtils.assertParameterNotNull(value, "value");
        return new ColumnValue(value, ColumnType.BINARY);
    }

    public String asString() {
        if (this.type != ColumnType.STRING) {
            throw new IllegalStateException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("DateTypeIsNot", "STRING"));
        }
        return this.value.toString();
    }

    public static ColumnValue fromString(String value) {
        CodingUtils.assertParameterNotNull(value, "value");
        return new ColumnValue(value, ColumnType.STRING);
    }

    public long asLong() {
        if (this.type != ColumnType.INTEGER) {
            throw new IllegalStateException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("DateTypeIsNot", "INTEGER"));
        }
        return (Long)this.value;
    }

    public double asDouble() {
        if (this.type != ColumnType.DOUBLE) {
            throw new IllegalStateException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("DateTypeIsNot", "DOUBLE"));
        }
        Double result = (Double)this.value;
        if (result == Double.POSITIVE_INFINITY) {
            return Double.MAX_VALUE;
        }
        if (result == Double.NEGATIVE_INFINITY) {
            return -1.7976931348623157E308;
        }
        return result;
    }

    public boolean asBoolean() {
        if (this.type != ColumnType.BOOLEAN) {
            throw new IllegalStateException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("DateTypeIsNot", "BOOLEAN"));
        }
        return (Boolean)this.value;
    }

    public byte[] asBinary() {
        if (this.type != ColumnType.BINARY) {
            throw new IllegalStateException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("DateTypeIsNot", "BINARY"));
        }
        return (byte[])this.value;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ColumnValue)) {
            return false;
        }
        ColumnValue val = (ColumnValue)o;
        return this.type == val.type && this.value.equals(val.value);
    }

    public int hashCode() {
        return this.value.hashCode() ^ this.type.hashCode();
    }

    public String toString() {
        return this.value.toString() + ":" + (Object)((Object)this.type);
    }
}

