/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.openservices.ots.internal.model.ResponseContentWithMeta;
import com.aliyun.openservices.ots.model.BatchGetRowResult;
import com.aliyun.openservices.ots.model.BatchWriteRowResult;
import com.aliyun.openservices.ots.model.CapacityUnit;
import com.aliyun.openservices.ots.model.CreateTableResult;
import com.aliyun.openservices.ots.model.DeleteRowResult;
import com.aliyun.openservices.ots.model.DeleteTableResult;
import com.aliyun.openservices.ots.model.DescribeTableResult;
import com.aliyun.openservices.ots.model.GetRangeResult;
import com.aliyun.openservices.ots.model.GetRowResult;
import com.aliyun.openservices.ots.model.ListTableResult;
import com.aliyun.openservices.ots.model.OTSProtocolHelper;
import com.aliyun.openservices.ots.model.PutRowResult;
import com.aliyun.openservices.ots.model.ReservedThroughputDetails;
import com.aliyun.openservices.ots.model.Row;
import com.aliyun.openservices.ots.model.RowPrimaryKey;
import com.aliyun.openservices.ots.model.UpdateRowResult;
import com.aliyun.openservices.ots.model.UpdateTableResult;
import com.aliyun.openservices.ots.protocol.OtsProtocol2;
import java.util.ArrayList;

public class OTSResultFactory {
    public static CreateTableResult createCreateTableResult(ResponseContentWithMeta response, OtsProtocol2.CreateTableResponse createTableResponse) {
        CreateTableResult result = new CreateTableResult(response.getMeta());
        return result;
    }

    public static ListTableResult createListTableResult(ResponseContentWithMeta response, OtsProtocol2.ListTableResponse listTableResponse) {
        ListTableResult result = new ListTableResult(response.getMeta());
        result.setTableNames(listTableResponse.getTableNamesList());
        return result;
    }

    public static DescribeTableResult createDescribeTableResult(ResponseContentWithMeta response, OtsProtocol2.DescribeTableResponse describeTableResponse) {
        DescribeTableResult result = new DescribeTableResult(response.getMeta());
        result.setTableMeta(OTSProtocolHelper.parseTableMeta(describeTableResponse.getTableMeta()));
        result.setReservedThroughputDetails(OTSProtocolHelper.parseCapacityUnitDetails(describeTableResponse.getReservedThroughputDetails()));
        return result;
    }

    public static DeleteTableResult createDeleteTableResult(ResponseContentWithMeta response, OtsProtocol2.DeleteTableResponse deleteTableResponse) {
        DeleteTableResult result = new DeleteTableResult(response.getMeta());
        return result;
    }

    public static UpdateTableResult createUpdateTableResult(ResponseContentWithMeta response, OtsProtocol2.UpdateTableResponse updateTableResponse) {
        UpdateTableResult result = new UpdateTableResult(response.getMeta());
        ReservedThroughputDetails capacityUnitDetails = new ReservedThroughputDetails();
        OtsProtocol2.ReservedThroughputDetails details = updateTableResponse.getReservedThroughputDetails();
        capacityUnitDetails.setLastIncreaseTime(details.getLastIncreaseTime());
        if (details.hasLastDecreaseTime()) {
            capacityUnitDetails.setLastDecreaseTime(details.getLastDecreaseTime());
        }
        capacityUnitDetails.setNumberOfDecreasesToday(details.getNumberOfDecreasesToday());
        OtsProtocol2.CapacityUnit cu = details.getCapacityUnit();
        CapacityUnit capacityUnit = new CapacityUnit();
        if (cu.hasRead()) {
            capacityUnit.setReadCapacityUnit(cu.getRead());
        }
        if (cu.hasWrite()) {
            capacityUnit.setWriteCapacityUnit(cu.getWrite());
        }
        capacityUnitDetails.setCapacityUnit(capacityUnit);
        result.setReservedThroughputDetails(capacityUnitDetails);
        return result;
    }

    public static GetRowResult createGetRowResult(ResponseContentWithMeta response, OtsProtocol2.GetRowResponse getRowResponse) {
        GetRowResult result = new GetRowResult(response.getMeta());
        result.setRow(OTSProtocolHelper.parseRow(getRowResponse.getRow()));
        result.setConsumedCapacity(OTSProtocolHelper.parseConsumedCapacity(getRowResponse.getConsumed()));
        return result;
    }

    public static PutRowResult createPutRowResult(ResponseContentWithMeta response, OtsProtocol2.PutRowResponse putRowResponse) {
        PutRowResult result = new PutRowResult(response.getMeta());
        result.setConsumedCapacity(OTSProtocolHelper.parseConsumedCapacity(putRowResponse.getConsumed()));
        return result;
    }

    public static UpdateRowResult createUpdateRowResult(ResponseContentWithMeta response, OtsProtocol2.UpdateRowResponse updateRowResponse) {
        UpdateRowResult result = new UpdateRowResult(response.getMeta());
        result.setConsumedCapacity(OTSProtocolHelper.parseConsumedCapacity(updateRowResponse.getConsumed()));
        return result;
    }

    public static DeleteRowResult createDeleteRowResult(ResponseContentWithMeta response, OtsProtocol2.DeleteRowResponse deleteRowResponse) {
        DeleteRowResult result = new DeleteRowResult(response.getMeta());
        result.setConsumedCapacity(OTSProtocolHelper.parseConsumedCapacity(deleteRowResponse.getConsumed()));
        return result;
    }

    public static GetRangeResult createGetRangeResult(ResponseContentWithMeta response, OtsProtocol2.GetRangeResponse getRangeResponse) {
        GetRangeResult result = new GetRangeResult();
        result.setConsumedCapacity(OTSProtocolHelper.parseConsumedCapacity(getRangeResponse.getConsumed()));
        if (getRangeResponse.getNextStartPrimaryKeyCount() == 0) {
            result.setNextStartPrimaryKey(null);
        } else {
            RowPrimaryKey nextStart = new RowPrimaryKey();
            result.setNextStartPrimaryKey(nextStart);
            for (OtsProtocol2.Column pbColumn : getRangeResponse.getNextStartPrimaryKeyList()) {
                nextStart.addPrimaryKeyColumn(pbColumn.getName(), OTSProtocolHelper.toPrimaryKeyValue(pbColumn.getValue()));
            }
        }
        ArrayList<Row> rows = new ArrayList<Row>();
        for (OtsProtocol2.Row row : getRangeResponse.getRowsList()) {
            rows.add(OTSProtocolHelper.parseRow(row));
        }
        result.setRows(rows);
        return result;
    }

    public static BatchGetRowResult createBatchGetRowResult(ResponseContentWithMeta response, OtsProtocol2.BatchGetRowResponse batchGetRowResponse) {
        BatchGetRowResult result = new BatchGetRowResult(response.getMeta());
        for (OtsProtocol2.TableInBatchGetRowResponse table : batchGetRowResponse.getTablesList()) {
            String tableName = table.getTableName();
            for (OtsProtocol2.RowInBatchGetRowResponse row : table.getRowsList()) {
                result.addResult(tableName, OTSProtocolHelper.parseBatchGetRowStatus(row));
            }
        }
        return result;
    }

    public static BatchWriteRowResult createBatchWriteRowResult(ResponseContentWithMeta response, OtsProtocol2.BatchWriteRowResponse batchWriteRowResponse) {
        BatchWriteRowResult result = new BatchWriteRowResult(response.getMeta());
        for (OtsProtocol2.TableInBatchWriteRowResponse table : batchWriteRowResponse.getTablesList()) {
            String tableName = table.getTableName();
            for (OtsProtocol2.RowInBatchWriteRowResponse row : table.getPutRowsList()) {
                result.addPutRowResult(tableName, OTSProtocolHelper.parseBatchWriteRowStatus(row));
            }
            for (OtsProtocol2.RowInBatchWriteRowResponse row : table.getUpdateRowsList()) {
                result.addUpdateRowResult(tableName, OTSProtocolHelper.parseBatchWriteRowStatus(row));
            }
            for (OtsProtocol2.RowInBatchWriteRowResponse row : table.getDeleteRowsList()) {
                result.addDeleteRowResult(tableName, OTSProtocolHelper.parseBatchWriteRowStatus(row));
            }
        }
        return result;
    }
}

