/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.ots.OTS;
import com.aliyun.openservices.ots.model.GetRangeRequest;
import com.aliyun.openservices.ots.model.GetRangeResult;
import com.aliyun.openservices.ots.model.RangeIteratorParameter;
import com.aliyun.openservices.ots.model.RangeRowQueryCriteria;
import com.aliyun.openservices.ots.model.Row;
import com.aliyun.openservices.ots.model.RowPrimaryKey;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class RowIterator
implements Iterator<Row> {
    private OTS ots;
    private RangeIteratorParameter parameter;
    private GetRangeResult result;
    private Iterator<Row> rowsIter;
    private int totalCount;
    private int bufferSize;
    private int rowsRead;

    public RowIterator(OTS ots, RangeIteratorParameter parameter) {
        this.ots = ots;
        this.parameter = parameter;
        this.rowsRead = 0;
        this.totalCount = parameter.getCount();
        this.bufferSize = parameter.getBufferSize();
        if (this.bufferSize == -1) {
            this.bufferSize = this.totalCount;
        } else if (this.totalCount != -1 && this.bufferSize > this.totalCount) {
            this.bufferSize = this.totalCount;
        }
        this.fetchData(this.buildRequest());
    }

    private GetRangeRequest buildRequest() {
        RangeRowQueryCriteria criteria = new RangeRowQueryCriteria(this.parameter.getTableName());
        criteria.setDirection(this.parameter.getDirection());
        criteria.setColumnsToGet(this.parameter.getColumnsToGet());
        if (this.result == null) {
            criteria.setInclusiveStartPrimaryKey(this.parameter.getInclusiveStartPrimaryKey());
        } else {
            criteria.setInclusiveStartPrimaryKey(this.result.getNextStartPrimaryKey());
        }
        criteria.setExclusiveEndPrimaryKey(this.parameter.getExclusiveEndPrimaryKey());
        if (this.bufferSize > 0) {
            if (this.totalCount != -1 && this.totalCount - this.rowsRead < this.bufferSize) {
                criteria.setLimit(this.totalCount - this.rowsRead);
            } else {
                criteria.setLimit(this.bufferSize);
            }
        }
        return new GetRangeRequest(criteria);
    }

    private void fetchData(GetRangeRequest request) {
        GetRangeResult result;
        this.result = result = this.ots.getRange(request);
        this.rowsIter = result.getRows().iterator();
        this.rowsRead += result.getRows().size();
    }

    private boolean isBufferHasMoreData() {
        return this.rowsIter.hasNext();
    }

    private Row getNextFromBuffer() {
        return this.rowsIter.next();
    }

    @Override
    public boolean hasNext() {
        if (this.isBufferHasMoreData()) {
            return true;
        }
        RowPrimaryKey nextToken = this.result.getNextStartPrimaryKey();
        return nextToken != null && !nextToken.getPrimaryKey().isEmpty() && this.totalCount != this.rowsRead;
    }

    @Override
    public Row next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.isBufferHasMoreData()) {
            return this.getNextFromBuffer();
        }
        this.fetchData(this.buildRequest());
        return this.next();
    }

    @Override
    public void remove() {
        throw new ClientException("RowIterator do not support remove().");
    }
}

