/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.model.PrimaryKeyType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class TableMeta {
    private String tableName;
    private Map<String, PrimaryKeyType> primaryKey = new LinkedHashMap<String, PrimaryKeyType>();

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        if (tableName == null) {
            throw new NullPointerException();
        }
        OTSUtil.ensureNameValid(tableName);
        this.tableName = tableName;
    }

    public Map<String, PrimaryKeyType> getPrimaryKey() {
        return Collections.unmodifiableMap(this.primaryKey);
    }

    public void addPrimaryKeyColumn(String name, PrimaryKeyType type) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (type == null) {
            throw new NullPointerException();
        }
        OTSUtil.ensureNameValid(name);
        this.primaryKey.put(name, type);
    }

    TableMeta() {
    }

    public TableMeta(String tableName) {
        if (tableName == null) {
            throw new NullPointerException();
        }
        OTSUtil.ensureNameValid(tableName);
        this.tableName = tableName;
    }
}

