/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.client.rocketmq.impl;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageSelector;
import com.aliyun.openservices.ons.api.TopicPartition;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.api.order.ConsumeOrderContext;
import com.aliyun.openservices.ons.api.order.MessageOrderListener;
import com.aliyun.openservices.ons.api.order.OrderAction;
import com.aliyun.openservices.ons.api.order.OrderConsumer;
import com.aliyun.openservices.ons.client.rocketmq.PushConsumer;
import com.aliyun.openservices.ons.client.utils.UtilAll;
import com.aliyun.openservices.ons.shaded.com.google.common.base.Optional;
import com.aliyun.openservices.ons.shaded.commons.lang3.StringUtils;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.consumer.ConsumeContext;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.consumer.ConsumeStatus;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.impl.consumer.OffsetStore;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageExt;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageQueue;
import com.aliyun.openservices.ons.shaded.org.slf4j.Logger;
import com.aliyun.openservices.ons.shaded.org.slf4j.LoggerFactory;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class OrderConsumerImpl
extends PushConsumer
implements OrderConsumer {
    private static final Logger log = LoggerFactory.getLogger(OrderConsumerImpl.class);
    private final ConcurrentMap<String, MessageOrderListener> subscribeTable = new ConcurrentHashMap<String, MessageOrderListener>();

    public OrderConsumerImpl(Properties properties) {
        super(properties);
        String suspendTimeMillisProps = properties.getProperty("suspendTimeMillis");
        if (StringUtils.isNoneBlank(suspendTimeMillisProps)) {
            long suspendTimeMillis = Long.parseLong(suspendTimeMillisProps);
            this.defaultMQPushConsumer.setFifoConsumptionSuspendTimeMillis(suspendTimeMillis);
        }
    }

    @Override
    public void start() {
        this.defaultMQPushConsumer.registerMessageListener(new MessageListenerImpl());
        log.info("Register order message listener successfully.");
        super.start();
    }

    @Override
    public void subscribe(String topic, String subExpression, MessageOrderListener listener) {
        MessageSelector selector = MessageSelector.byTag(subExpression);
        this.subscribe(topic, selector, listener);
    }

    @Override
    public void subscribe(String topic, MessageSelector selector, MessageOrderListener listener) {
        if (StringUtils.isBlank(topic)) {
            throw new ONSClientException("Topic is blank unexpectedly, please set it.");
        }
        if (null == listener) {
            throw new ONSClientException("Order listener is null, please set it.");
        }
        this.subscribeTable.put(topic, listener);
        super.subscribe(topic, selector);
    }

    @Override
    public void setOffsetStore(final com.aliyun.openservices.ons.api.OffsetStore offsetStore) {
        if (null == offsetStore) {
            throw new ONSClientException("OffsetStore is null, please set it.");
        }
        this.defaultMQPushConsumer.setOffsetStore(new OffsetStore(){

            @Override
            public void start() {
                offsetStore.start();
            }

            @Override
            public void shutdown() {
                offsetStore.shutdown();
            }

            @Override
            public void updateOffset(MessageQueue mq, long offset) {
                TopicPartition partition = UtilAll.convertToPartition(mq);
                offsetStore.updateOffset(partition, offset);
            }

            @Override
            public Optional<Long> readOffset(MessageQueue mq) {
                TopicPartition partition = UtilAll.convertToPartition(mq);
                return offsetStore.readOffset(partition);
            }
        });
    }

    @Override
    public void rateLimit(String topic, double permitsPerSecond) {
        this.defaultMQPushConsumer.rateLimit(topic, permitsPerSecond);
    }

    @Override
    public void unsubscribe(String topic) {
        if (StringUtils.isBlank(topic)) {
            return;
        }
        this.subscribeTable.remove(topic);
        super.unsubscribe(topic);
    }

    class MessageListenerImpl
    extends MessageListenerOrderly {
        MessageListenerImpl() {
        }

        @Override
        public ConsumeStatus consume(List<MessageExt> msgList, ConsumeContext consumeContext) {
            MessageExt rmqMessageExt = msgList.get(0);
            Message message = UtilAll.msgConvert(rmqMessageExt);
            String topic = message.getTopic();
            MessageOrderListener messageListener = (MessageOrderListener)OrderConsumerImpl.this.subscribeTable.get(topic);
            if (null == messageListener) {
                throw new ONSClientException("MessageListener is null.");
            }
            ConsumeOrderContext context = new ConsumeOrderContext();
            OrderAction action = messageListener.consume(message, context);
            switch (action) {
                case Success: {
                    return ConsumeStatus.OK;
                }
            }
            return ConsumeStatus.ERROR;
        }
    }
}

