/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.client.rocketmq.impl;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.OnExceptionContext;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.api.order.OrderProducer;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionChecker;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionExecuter;
import com.aliyun.openservices.ons.api.transaction.TransactionProducer;
import com.aliyun.openservices.ons.api.transaction.TransactionStatus;
import com.aliyun.openservices.ons.client.ClientAbstract;
import com.aliyun.openservices.ons.client.utils.UtilAll;
import com.aliyun.openservices.ons.shaded.commons.lang3.StringUtils;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.exception.ClientException;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageExt;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.producer.DefaultMQProducer;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.producer.SendCallback;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.producer.SendResult;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.producer.Transaction;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.producer.TransactionChecker;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.producer.TransactionResolution;
import com.aliyun.openservices.ons.shaded.org.slf4j.Logger;
import com.aliyun.openservices.ons.shaded.org.slf4j.LoggerFactory;
import java.util.Properties;
import java.util.concurrent.ExecutorService;

public class ProducerImpl
extends ClientAbstract
implements Producer,
OrderProducer,
TransactionProducer {
    private static final Logger log = LoggerFactory.getLogger(ProducerImpl.class);
    private static final String DEFAULT_PRODUCER_GROUP = "__ONS_PRODUCER_DEFAULT_GROUP";
    private static final long DEFAULT_SEND_MSG_TIMEOUT_MILLIS = 5000L;
    private static final long DEFAULT_TRANSACTION_RESOLVE_DELAY_MILLIS = 5000L;
    protected final DefaultMQProducer defaultMQProducer;
    protected final String groupId;

    public ProducerImpl(Properties properties) {
        super(properties);
        this.groupId = properties.getProperty("GROUP_ID", DEFAULT_PRODUCER_GROUP);
        if (StringUtils.isBlank(this.groupId)) {
            throw new ONSClientException("Group id is blank, please set it.");
        }
        try {
            this.defaultMQProducer = new DefaultMQProducer(this.groupId);
        }
        catch (ClientException e) {
            throw new ONSClientException(e);
        }
        this.defaultMQProducer.setCredentialsProvider(this.provider);
        long sendMessageTimeoutMillis = 5000L;
        String sendMessageTimeoutMillisProp = properties.getProperty("SendMsgTimeoutMillis");
        if (StringUtils.isNoneBlank(sendMessageTimeoutMillisProp)) {
            sendMessageTimeoutMillis = Long.parseLong(sendMessageTimeoutMillisProp);
        }
        this.defaultMQProducer.setSendMessageTimeoutMillis(sendMessageTimeoutMillis);
        long transactionResolveDelayMillis = 5000L;
        String transactionResolveDelayMillisProp = properties.getProperty("CheckImmunityTimeInSeconds");
        if (StringUtils.isNoneBlank(transactionResolveDelayMillisProp)) {
            transactionResolveDelayMillis = Long.parseLong(transactionResolveDelayMillisProp);
        }
        this.defaultMQProducer.setTransactionRecoverDelayMillis(transactionResolveDelayMillis);
        try {
            this.defaultMQProducer.setNamesrvAddr(this.nameServerAddr);
        }
        catch (Throwable t) {
            throw new ONSClientException(t);
        }
        if (null != this.namespace) {
            this.defaultMQProducer.setNamespace(this.namespace);
        }
        this.defaultMQProducer.setMessageTracingEnabled(this.messageTracingEnabled);
    }

    public ProducerImpl(Properties properties, final LocalTransactionChecker localChecker) {
        this(properties);
        TransactionChecker transactionChecker = new TransactionChecker(){

            @Override
            public TransactionResolution check(MessageExt messageExt) {
                TransactionStatus status = localChecker.check(UtilAll.msgConvert(messageExt));
                switch (status) {
                    case CommitTransaction: {
                        return TransactionResolution.COMMIT;
                    }
                    case RollbackTransaction: {
                        return TransactionResolution.ROLLBACK;
                    }
                }
                return TransactionResolution.UNKNOWN;
            }
        };
        this.defaultMQProducer.setTransactionChecker(transactionChecker);
    }

    private ONSClientException producerExceptionConvert(String topic, String msgId, Throwable t) {
        log.info("Exception raised for producer, namespace={}, topic={}, messageId={}", this.defaultMQProducer.getNamespace(), topic, msgId, t);
        return new ONSClientException(t);
    }

    private OnExceptionContext producerExceptionContextConvert(Message message, Throwable t) {
        ONSClientException exception = this.producerExceptionConvert(message.getTopic(), message.getMsgID(), t);
        return new OnExceptionContext(message.getTopic(), message.getMsgID(), exception);
    }

    @Override
    public void start() {
        try {
            if (this.started.compareAndSet(false, true)) {
                log.info("Begin to start the ONS producer.");
                this.defaultMQProducer.start();
                log.info("ONS producer starts successfully.");
                return;
            }
            log.warn("ONS producer has been started before.");
        }
        catch (Throwable t) {
            log.error("Failed to start the ONS producer.");
            throw new ONSClientException(t);
        }
    }

    @Override
    public void shutdown() {
        try {
            if (this.started.compareAndSet(true, false)) {
                log.info("Begin to shutdown the ONS producer.");
                this.defaultMQProducer.shutdown();
                log.info("Shutdown ONS producer successfully.");
                return;
            }
            log.warn("ONS producer has been shutdown before.");
        }
        catch (Throwable t) {
            log.error("Failed to shutdown the ONS producer.");
            throw new ONSClientException(t);
        }
    }

    @Override
    public com.aliyun.openservices.ons.api.SendResult send(Message message) {
        com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.Message msg = UtilAll.msgConvert(message);
        try {
            SendResult sendResult = this.defaultMQProducer.send(msg);
            return new com.aliyun.openservices.ons.api.SendResult(message.getTopic(), sendResult.getMsgId());
        }
        catch (Throwable t) {
            throw this.producerExceptionConvert(message.getTopic(), message.getMsgID(), t);
        }
    }

    @Override
    public void sendOneway(Message message) {
        com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.Message msg = UtilAll.msgConvert(message);
        try {
            this.defaultMQProducer.sendOneway(msg);
        }
        catch (Throwable t) {
            throw this.producerExceptionConvert(message.getTopic(), message.getMsgID(), t);
        }
    }

    @Override
    public void sendAsync(final Message message, final com.aliyun.openservices.ons.api.SendCallback sendCallback) {
        try {
            com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.Message msg = UtilAll.msgConvert(message);
            this.defaultMQProducer.send(msg, new SendCallback(){

                @Override
                public void onSuccess(SendResult mqSendResult) {
                    com.aliyun.openservices.ons.api.SendResult sendResult = new com.aliyun.openservices.ons.api.SendResult(message.getTopic(), mqSendResult.getMsgId());
                    sendCallback.onSuccess(sendResult);
                }

                @Override
                public void onException(Throwable t) {
                    OnExceptionContext context = ProducerImpl.this.producerExceptionContextConvert(message, t);
                    sendCallback.onException(context);
                }
            });
        }
        catch (Throwable t) {
            throw this.producerExceptionConvert(message.getTopic(), message.getMsgID(), t);
        }
    }

    @Override
    public void setCallbackExecutor(ExecutorService callbackExecutor) {
        this.defaultMQProducer.setCallbackExecutor(callbackExecutor);
    }

    @Override
    public com.aliyun.openservices.ons.api.SendResult send(Message message, String shardingKey) {
        com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.Message msg = UtilAll.msgConvert(message);
        try {
            SendResult sendResult = this.defaultMQProducer.send(msg, shardingKey);
            return new com.aliyun.openservices.ons.api.SendResult(message.getTopic(), sendResult.getMsgId());
        }
        catch (Throwable t) {
            throw this.producerExceptionConvert(message.getTopic(), message.getMsgID(), t);
        }
    }

    @Override
    public com.aliyun.openservices.ons.api.SendResult send(Message message, LocalTransactionExecuter executor, Object arg) {
        com.aliyun.openservices.ons.api.SendResult sendResult;
        Transaction transaction;
        com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.Message msg = UtilAll.msgConvert(message);
        if (null == executor) {
            throw new ONSClientException("Local executor is null unexpectedly");
        }
        try {
            transaction = this.defaultMQProducer.prepare(msg);
            sendResult = new com.aliyun.openservices.ons.api.SendResult(message.getTopic(), transaction.getSendResult().getMsgId());
        }
        catch (Throwable t) {
            throw new ONSClientException(t);
        }
        TransactionStatus status = null;
        try {
            status = executor.execute(message, arg);
            switch (status) {
                case CommitTransaction: {
                    transaction.commit();
                    break;
                }
                case RollbackTransaction: {
                    transaction.rollback();
                    break;
                }
            }
        }
        catch (Throwable t) {
            log.info("Exception raised while execute local executor and end message", t);
        }
        if (TransactionStatus.RollbackTransaction.equals((Object)status)) {
            throw new ONSClientException("local transaction branch return rollback");
        }
        return sendResult;
    }
}

