/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.internal.Utils;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.AsynchronousInstrument;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.BatchRecorder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.BoundDoubleCounter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.BoundDoubleUpDownCounter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.BoundDoubleValueRecorder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.BoundLongCounter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.BoundLongUpDownCounter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.BoundLongValueRecorder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.DoubleCounter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.DoubleCounterBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.DoubleSumObserver;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.DoubleSumObserverBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.DoubleUpDownCounter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.DoubleUpDownCounterBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.DoubleUpDownSumObserver;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.DoubleUpDownSumObserverBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.DoubleValueObserver;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.DoubleValueObserverBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.DoubleValueRecorder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.DoubleValueRecorderBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.InstrumentBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.LongCounter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.LongCounterBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.LongSumObserver;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.LongSumObserverBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.LongUpDownCounter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.LongUpDownCounterBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.LongUpDownSumObserver;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.LongUpDownSumObserverBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.LongValueObserver;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.LongValueObserverBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.LongValueRecorder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.LongValueRecorderBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.Meter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.common.Consumer;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.common.Labels;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.internal.MetricsStringUtils;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class DefaultMeter
implements Meter {
    private static final DefaultMeter INSTANCE = new DefaultMeter();
    private static final String COUNTERS_CAN_ONLY_INCREASE = "Counters can only increase";
    static final String ERROR_MESSAGE_INVALID_NAME = "Name should be a ASCII string with a length no greater than 255 characters.";

    static Meter getInstance() {
        return INSTANCE;
    }

    @Override
    public DoubleCounterBuilder doubleCounterBuilder(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Utils.checkArgument(MetricsStringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopDoubleCounter.NoopBuilder();
    }

    @Override
    public LongCounterBuilder longCounterBuilder(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Utils.checkArgument(MetricsStringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopLongCounter.NoopBuilder();
    }

    @Override
    public DoubleUpDownCounterBuilder doubleUpDownCounterBuilder(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Utils.checkArgument(MetricsStringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopDoubleUpDownCounter.NoopBuilder();
    }

    @Override
    public LongUpDownCounterBuilder longUpDownCounterBuilder(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Utils.checkArgument(MetricsStringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopLongUpDownCounter.NoopBuilder();
    }

    @Override
    public DoubleValueRecorderBuilder doubleValueRecorderBuilder(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Utils.checkArgument(MetricsStringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopDoubleValueRecorder.NoopBuilder();
    }

    @Override
    public LongValueRecorderBuilder longValueRecorderBuilder(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Utils.checkArgument(MetricsStringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopLongValueRecorder.NoopBuilder();
    }

    @Override
    public DoubleSumObserverBuilder doubleSumObserverBuilder(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Utils.checkArgument(MetricsStringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopDoubleSumObserver.NoopBuilder();
    }

    @Override
    public LongSumObserverBuilder longSumObserverBuilder(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Utils.checkArgument(MetricsStringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopLongSumObserver.NoopBuilder();
    }

    @Override
    public DoubleUpDownSumObserverBuilder doubleUpDownSumObserverBuilder(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Utils.checkArgument(MetricsStringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopDoubleUpDownSumObserver.NoopBuilder();
    }

    @Override
    public LongUpDownSumObserverBuilder longUpDownSumObserverBuilder(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Utils.checkArgument(MetricsStringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopLongUpDownSumObserver.NoopBuilder();
    }

    @Override
    public DoubleValueObserverBuilder doubleValueObserverBuilder(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Utils.checkArgument(MetricsStringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopDoubleValueObserver.NoopBuilder();
    }

    @Override
    public LongValueObserverBuilder longValueObserverBuilder(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Utils.checkArgument(MetricsStringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopLongValueObserver.NoopBuilder();
    }

    @Override
    public BatchRecorder newBatchRecorder(String ... keyValuePairs) {
        DefaultMeter.validateLabelPairs(keyValuePairs);
        return NoopBatchRecorder.INSTANCE;
    }

    private DefaultMeter() {
    }

    private static void validateLabelPairs(String[] keyValuePairs) {
        Utils.checkArgument(keyValuePairs.length % 2 == 0, "You must provide an even number of key/value pair arguments.");
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            String key = keyValuePairs[i];
            if (key != null) continue;
            throw new NullPointerException("You cannot provide null keys for label creation.");
        }
    }

    private static abstract class NoopAbstractInstrumentBuilder<B extends NoopAbstractInstrumentBuilder<B>>
    implements InstrumentBuilder {
        private NoopAbstractInstrumentBuilder() {
        }

        public B setDescription(String description) {
            if (description == null) {
                throw new NullPointerException("description");
            }
            return this.getThis();
        }

        public B setUnit(String unit) {
            if (unit == null) {
                throw new NullPointerException("unit");
            }
            return this.getThis();
        }

        protected abstract B getThis();
    }

    private static enum NoopBatchRecorder implements BatchRecorder
    {
        INSTANCE;


        @Override
        public BatchRecorder put(LongValueRecorder valueRecorder, long value) {
            if (valueRecorder == null) {
                throw new NullPointerException("valueRecorder");
            }
            return this;
        }

        @Override
        public BatchRecorder put(DoubleValueRecorder valueRecorder, double value) {
            if (valueRecorder == null) {
                throw new NullPointerException("valueRecorder");
            }
            return this;
        }

        @Override
        public BatchRecorder put(LongCounter counter, long value) {
            if (counter == null) {
                throw new NullPointerException("counter");
            }
            Utils.checkArgument(value >= 0L, DefaultMeter.COUNTERS_CAN_ONLY_INCREASE);
            return this;
        }

        @Override
        public BatchRecorder put(DoubleCounter counter, double value) {
            if (counter == null) {
                throw new NullPointerException("counter");
            }
            Utils.checkArgument(value >= 0.0, DefaultMeter.COUNTERS_CAN_ONLY_INCREASE);
            return this;
        }

        @Override
        public BatchRecorder put(LongUpDownCounter upDownCounter, long value) {
            if (upDownCounter == null) {
                throw new NullPointerException("upDownCounter");
            }
            return this;
        }

        @Override
        public BatchRecorder put(DoubleUpDownCounter upDownCounter, double value) {
            if (upDownCounter == null) {
                throw new NullPointerException("upDownCounter");
            }
            return this;
        }

        @Override
        public void record() {
        }
    }

    @Immutable
    private static final class NoopLongValueObserver
    implements LongValueObserver {
        private NoopLongValueObserver() {
        }

        private static final class NoopBuilder
        extends NoopAbstractInstrumentBuilder<NoopBuilder>
        implements LongValueObserverBuilder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public LongValueObserverBuilder setUpdater(Consumer<AsynchronousInstrument.LongResult> updater) {
                if (updater == null) {
                    throw new NullPointerException("callback");
                }
                return this;
            }

            @Override
            public LongValueObserver build() {
                return new NoopLongValueObserver();
            }
        }
    }

    @Immutable
    private static final class NoopDoubleValueObserver
    implements DoubleValueObserver {
        private NoopDoubleValueObserver() {
        }

        private static final class NoopBuilder
        extends NoopAbstractInstrumentBuilder<NoopBuilder>
        implements DoubleValueObserverBuilder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public DoubleValueObserverBuilder setUpdater(Consumer<AsynchronousInstrument.DoubleResult> updater) {
                if (updater == null) {
                    throw new NullPointerException("callback");
                }
                return this;
            }

            @Override
            public DoubleValueObserver build() {
                return new NoopDoubleValueObserver();
            }
        }
    }

    @Immutable
    private static final class NoopLongUpDownSumObserver
    implements LongUpDownSumObserver {
        private NoopLongUpDownSumObserver() {
        }

        private static final class NoopBuilder
        extends NoopAbstractInstrumentBuilder<NoopBuilder>
        implements LongUpDownSumObserverBuilder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public LongUpDownSumObserverBuilder setUpdater(Consumer<AsynchronousInstrument.LongResult> updater) {
                if (updater == null) {
                    throw new NullPointerException("callback");
                }
                return this;
            }

            @Override
            public LongUpDownSumObserver build() {
                return new NoopLongUpDownSumObserver();
            }
        }
    }

    @Immutable
    private static final class NoopDoubleUpDownSumObserver
    implements DoubleUpDownSumObserver {
        private NoopDoubleUpDownSumObserver() {
        }

        private static final class NoopBuilder
        extends NoopAbstractInstrumentBuilder<NoopBuilder>
        implements DoubleUpDownSumObserverBuilder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public DoubleUpDownSumObserverBuilder setUpdater(Consumer<AsynchronousInstrument.DoubleResult> updater) {
                if (updater == null) {
                    throw new NullPointerException("callback");
                }
                return this;
            }

            @Override
            public DoubleUpDownSumObserver build() {
                return new NoopDoubleUpDownSumObserver();
            }
        }
    }

    @Immutable
    private static final class NoopLongSumObserver
    implements LongSumObserver {
        private NoopLongSumObserver() {
        }

        private static final class NoopBuilder
        extends NoopAbstractInstrumentBuilder<NoopBuilder>
        implements LongSumObserverBuilder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public NoopBuilder setUpdater(Consumer<AsynchronousInstrument.LongResult> updater) {
                if (updater == null) {
                    throw new NullPointerException("callback");
                }
                return this;
            }

            @Override
            public LongSumObserver build() {
                return new NoopLongSumObserver();
            }
        }
    }

    @Immutable
    private static final class NoopDoubleSumObserver
    implements DoubleSumObserver {
        private NoopDoubleSumObserver() {
        }

        private static final class NoopBuilder
        extends NoopAbstractInstrumentBuilder<NoopBuilder>
        implements DoubleSumObserverBuilder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public DoubleSumObserverBuilder setUpdater(Consumer<AsynchronousInstrument.DoubleResult> updater) {
                if (updater == null) {
                    throw new NullPointerException("callback");
                }
                return this;
            }

            @Override
            public DoubleSumObserver build() {
                return new NoopDoubleSumObserver();
            }
        }
    }

    @Immutable
    private static final class NoopLongValueRecorder
    implements LongValueRecorder {
        private NoopLongValueRecorder() {
        }

        @Override
        public void record(long value, Labels labels) {
            if (labels == null) {
                throw new NullPointerException("labels");
            }
        }

        @Override
        public void record(long value) {
            this.record(value, Labels.empty());
        }

        @Override
        public NoopBoundLongValueRecorder bind(Labels labels) {
            if (labels == null) {
                throw new NullPointerException("labels");
            }
            return NoopBoundLongValueRecorder.INSTANCE;
        }

        private static final class NoopBuilder
        extends NoopAbstractInstrumentBuilder<NoopBuilder>
        implements LongValueRecorderBuilder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public LongValueRecorder build() {
                return new NoopLongValueRecorder();
            }
        }

        @Immutable
        private static enum NoopBoundLongValueRecorder implements BoundLongValueRecorder
        {
            INSTANCE;


            @Override
            public void record(long value) {
            }

            @Override
            public void unbind() {
            }
        }
    }

    @Immutable
    private static final class NoopDoubleValueRecorder
    implements DoubleValueRecorder {
        private NoopDoubleValueRecorder() {
        }

        @Override
        public void record(double value, Labels labels) {
            if (labels == null) {
                throw new NullPointerException("labels");
            }
        }

        @Override
        public void record(double value) {
            this.record(value, Labels.empty());
        }

        @Override
        public NoopBoundDoubleValueRecorder bind(Labels labels) {
            if (labels == null) {
                throw new NullPointerException("labels");
            }
            return NoopBoundDoubleValueRecorder.INSTANCE;
        }

        private static final class NoopBuilder
        extends NoopAbstractInstrumentBuilder<NoopBuilder>
        implements DoubleValueRecorderBuilder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public DoubleValueRecorder build() {
                return new NoopDoubleValueRecorder();
            }
        }

        @Immutable
        private static enum NoopBoundDoubleValueRecorder implements BoundDoubleValueRecorder
        {
            INSTANCE;


            @Override
            public void record(double value) {
            }

            @Override
            public void unbind() {
            }
        }
    }

    @Immutable
    private static final class NoopLongUpDownCounter
    implements LongUpDownCounter {
        private NoopLongUpDownCounter() {
        }

        @Override
        public void add(long increment, Labels labels) {
            if (labels == null) {
                throw new NullPointerException("labels");
            }
        }

        @Override
        public void add(long increment) {
            this.add(increment, Labels.empty());
        }

        @Override
        public NoopBoundLongUpDownCounter bind(Labels labels) {
            if (labels == null) {
                throw new NullPointerException("labels");
            }
            return NoopBoundLongUpDownCounter.INSTANCE;
        }

        private static final class NoopBuilder
        extends NoopAbstractInstrumentBuilder<NoopBuilder>
        implements LongUpDownCounterBuilder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public LongUpDownCounter build() {
                return new NoopLongUpDownCounter();
            }
        }

        @Immutable
        private static enum NoopBoundLongUpDownCounter implements BoundLongUpDownCounter
        {
            INSTANCE;


            @Override
            public void add(long increment) {
            }

            @Override
            public void unbind() {
            }
        }
    }

    @Immutable
    private static final class NoopDoubleUpDownCounter
    implements DoubleUpDownCounter {
        private NoopDoubleUpDownCounter() {
        }

        @Override
        public void add(double increment, Labels labels) {
            if (labels == null) {
                throw new NullPointerException("labels");
            }
        }

        @Override
        public void add(double increment) {
            this.add(increment, Labels.empty());
        }

        @Override
        public NoopBoundDoubleUpDownCounter bind(Labels labels) {
            if (labels == null) {
                throw new NullPointerException("labels");
            }
            return NoopBoundDoubleUpDownCounter.INSTANCE;
        }

        private static final class NoopBuilder
        extends NoopAbstractInstrumentBuilder<NoopBuilder>
        implements DoubleUpDownCounterBuilder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public DoubleUpDownCounter build() {
                return new NoopDoubleUpDownCounter();
            }
        }

        @Immutable
        private static enum NoopBoundDoubleUpDownCounter implements BoundDoubleUpDownCounter
        {
            INSTANCE;


            @Override
            public void add(double increment) {
            }

            @Override
            public void unbind() {
            }
        }
    }

    @Immutable
    private static final class NoopLongCounter
    implements LongCounter {
        private NoopLongCounter() {
        }

        @Override
        public void add(long increment, Labels labels) {
            if (labels == null) {
                throw new NullPointerException("labels");
            }
            Utils.checkArgument(increment >= 0L, DefaultMeter.COUNTERS_CAN_ONLY_INCREASE);
        }

        @Override
        public void add(long increment) {
            this.add(increment, Labels.empty());
        }

        @Override
        public NoopBoundLongCounter bind(Labels labels) {
            if (labels == null) {
                throw new NullPointerException("labels");
            }
            return NoopBoundLongCounter.INSTANCE;
        }

        private static final class NoopBuilder
        extends NoopAbstractInstrumentBuilder<NoopBuilder>
        implements LongCounterBuilder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public LongCounter build() {
                return new NoopLongCounter();
            }
        }

        @Immutable
        private static enum NoopBoundLongCounter implements BoundLongCounter
        {
            INSTANCE;


            @Override
            public void add(long increment) {
                Utils.checkArgument(increment >= 0L, DefaultMeter.COUNTERS_CAN_ONLY_INCREASE);
            }

            @Override
            public void unbind() {
            }
        }
    }

    @Immutable
    private static final class NoopDoubleCounter
    implements DoubleCounter {
        private NoopDoubleCounter() {
        }

        @Override
        public void add(double increment, Labels labels) {
            if (labels == null) {
                throw new NullPointerException("labels");
            }
            Utils.checkArgument(increment >= 0.0, DefaultMeter.COUNTERS_CAN_ONLY_INCREASE);
        }

        @Override
        public void add(double increment) {
            this.add(increment, Labels.empty());
        }

        @Override
        public NoopBoundDoubleCounter bind(Labels labels) {
            if (labels == null) {
                throw new NullPointerException("labels");
            }
            return NoopBoundDoubleCounter.INSTANCE;
        }

        private static final class NoopBuilder
        extends NoopAbstractInstrumentBuilder<NoopBuilder>
        implements DoubleCounterBuilder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public DoubleCounter build() {
                return new NoopDoubleCounter();
            }
        }

        @Immutable
        private static enum NoopBoundDoubleCounter implements BoundDoubleCounter
        {
            INSTANCE;


            @Override
            public void add(double increment) {
                Utils.checkArgument(increment >= 0.0, DefaultMeter.COUNTERS_CAN_ONLY_INCREASE);
            }

            @Override
            public void unbind() {
            }
        }
    }
}

