/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.common.AttributeKey;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.common.Attributes;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.internal.BiConsumer;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.PropagatedSpan;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.SpanContext;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.SpanContextKey;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.StatusCode;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.context.Context;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.context.ImplicitContextKeyed;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class Span
extends ImplicitContextKeyed {
    public static Span current() {
        Span span = Context.current().get(SpanContextKey.KEY);
        return span == null ? Span.getInvalid() : span;
    }

    public static Span fromContext(Context context) {
        if (context == null) {
            return Span.getInvalid();
        }
        Span span = context.get(SpanContextKey.KEY);
        return span == null ? Span.getInvalid() : span;
    }

    @Nullable
    public static Span fromContextOrNull(Context context) {
        if (context == null) {
            return null;
        }
        return context.get(SpanContextKey.KEY);
    }

    public static Span getInvalid() {
        return PropagatedSpan.INVALID;
    }

    public static Span wrap(SpanContext spanContext) {
        if (spanContext == null || !spanContext.isValid()) {
            return Span.getInvalid();
        }
        return PropagatedSpan.create(spanContext);
    }

    public Span setAttribute(String key, String value) {
        return this.setAttribute(AttributeKey.stringKey(key), value);
    }

    public Span setAttribute(String key, long value) {
        return this.setAttribute(AttributeKey.longKey(key), Long.valueOf(value));
    }

    public Span setAttribute(String key, double value) {
        return this.setAttribute(AttributeKey.doubleKey(key), Double.valueOf(value));
    }

    public Span setAttribute(String key, boolean value) {
        return this.setAttribute(AttributeKey.booleanKey(key), Boolean.valueOf(value));
    }

    public abstract <T> Span setAttribute(AttributeKey<T> var1, T var2);

    public Span setAttribute(AttributeKey<Long> key, int value) {
        return this.setAttribute(key, Long.valueOf(value));
    }

    public Span setAllAttributes(Attributes attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return this;
        }
        attributes.forEach(new BiConsumer<AttributeKey<?>, Object>(){

            @Override
            public void accept(AttributeKey<?> attributeKey, Object value) {
                Span.this.setAttribute(attributeKey, value);
            }
        });
        return this;
    }

    public Span addEvent(String name) {
        return this.addEvent(name, Attributes.empty());
    }

    public Span addEvent(String name, long timestamp, TimeUnit unit) {
        return this.addEvent(name, Attributes.empty(), timestamp, unit);
    }

    public abstract Span addEvent(String var1, Attributes var2);

    public abstract Span addEvent(String var1, Attributes var2, long var3, TimeUnit var5);

    public Span setStatus(StatusCode statusCode) {
        return this.setStatus(statusCode, "");
    }

    public abstract Span setStatus(StatusCode var1, String var2);

    public Span recordException(Throwable exception) {
        return this.recordException(exception, Attributes.empty());
    }

    public abstract Span recordException(Throwable var1, Attributes var2);

    public abstract Span updateName(String var1);

    public abstract void end();

    public abstract void end(long var1, TimeUnit var3);

    public abstract SpanContext getSpanContext();

    public abstract boolean isRecording();

    @Override
    public Context storeInContext(Context context) {
        return context.with(SpanContextKey.KEY, this);
    }
}

