/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.internal.OtelEncodingUtils;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.ImmutableSpanContext;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.SpanId;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.TraceFlags;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.TraceId;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.TraceState;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class SpanContext {
    public static SpanContext getInvalid() {
        return ImmutableSpanContext.INVALID;
    }

    public static SpanContext create(String traceIdHex, String spanIdHex, TraceFlags traceFlags, TraceState traceState) {
        return ImmutableSpanContext.create(traceIdHex, spanIdHex, traceFlags, traceState, false);
    }

    public static SpanContext createFromRemoteParent(String traceIdHex, String spanIdHex, TraceFlags traceFlags, TraceState traceState) {
        return ImmutableSpanContext.create(traceIdHex, spanIdHex, traceFlags, traceState, true);
    }

    public abstract String getTraceId();

    public byte[] getTraceIdBytes() {
        return OtelEncodingUtils.bytesFromBase16(this.getTraceId(), TraceId.getLength());
    }

    public abstract String getSpanId();

    public byte[] getSpanIdBytes() {
        return OtelEncodingUtils.bytesFromBase16(this.getSpanId(), SpanId.getLength());
    }

    public boolean isSampled() {
        return this.getTraceFlags().isSampled();
    }

    public abstract TraceFlags getTraceFlags();

    public abstract TraceState getTraceState();

    public boolean isValid() {
        return TraceId.isValid(this.getTraceId()) && SpanId.isValid(this.getSpanId());
    }

    public abstract boolean isRemote();
}

