/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.context;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.context.ArrayBasedContext;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.context.ContextExecutorService;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.context.ContextKey;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.context.ContextScheduledExecutorService;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.context.ContextStorage;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.context.CurrentContextExecutorService;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.context.ImplicitContextKeyed;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.context.Scope;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;

public abstract class Context {
    public static Context current() {
        Context current = ContextStorage.get().current();
        return current != null ? current : Context.root();
    }

    public static Context root() {
        return ArrayBasedContext.root();
    }

    public static Executor taskWrapping(final Executor executor) {
        return new Executor(){

            @Override
            public void execute(Runnable command) {
                executor.execute(Context.current().wrap(command));
            }
        };
    }

    public static ExecutorService taskWrapping(ExecutorService executorService) {
        return new CurrentContextExecutorService(executorService);
    }

    @Nullable
    public abstract <V> V get(ContextKey<V> var1);

    public abstract <V> Context with(ContextKey<V> var1, V var2);

    public Context with(ImplicitContextKeyed value) {
        return value.storeInContext(this);
    }

    public Scope makeCurrent() {
        return ContextStorage.get().attach(this);
    }

    public Runnable wrap(final Runnable runnable) {
        return new Runnable(){

            @Override
            public void run() {
                Scope scope = Context.this.makeCurrent();
                try {
                    runnable.run();
                }
                finally {
                    scope.close();
                }
            }
        };
    }

    public <T> Callable<T> wrap(final Callable<T> callable) {
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                Scope scope = Context.this.makeCurrent();
                try {
                    Object v = callable.call();
                    return v;
                }
                finally {
                    scope.close();
                }
            }
        };
    }

    public Executor wrap(final Executor executor) {
        return new Executor(){

            @Override
            public void execute(Runnable command) {
                executor.execute(Context.this.wrap(command));
            }
        };
    }

    public ExecutorService wrap(ExecutorService executor) {
        return new ContextExecutorService(this, executor);
    }

    public ScheduledExecutorService wrap(ScheduledExecutorService executor) {
        return new ContextScheduledExecutorService(this, executor);
    }
}

