/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.internal.Utils;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.Instrument;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.InstrumentBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.internal.MetricsStringUtils;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.common.InstrumentType;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.common.InstrumentValueType;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.List;

abstract class AbstractInstrument
implements Instrument {
    private final InstrumentDescriptor descriptor;

    AbstractInstrument(InstrumentDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    final InstrumentDescriptor getDescriptor() {
        return this.descriptor;
    }

    abstract List<MetricData> collectAll(long var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractInstrument)) {
            return false;
        }
        AbstractInstrument that = (AbstractInstrument)o;
        return this.descriptor.equals(that.descriptor);
    }

    public int hashCode() {
        return this.descriptor.hashCode();
    }

    static abstract class Builder<B extends Builder<?>>
    implements InstrumentBuilder {
        static final String ERROR_MESSAGE_INVALID_NAME = "Name should be a ASCII string with a length no greater than 255 characters.";
        private final String name;
        private final InstrumentType instrumentType;
        private final InstrumentValueType instrumentValueType;
        private static final String description = "";
        private static final String unit = "1";

        Builder(String name, InstrumentType instrumentType, InstrumentValueType instrumentValueType) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            Utils.checkArgument(MetricsStringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
            this.name = name;
            this.instrumentType = instrumentType;
            this.instrumentValueType = instrumentValueType;
        }

        public final B setDescription(String description) {
            if (description == null) {
                throw new NullPointerException("description");
            }
            return this.getThis();
        }

        public final B setUnit(String unit) {
            if (unit == null) {
                throw new NullPointerException("unit");
            }
            return this.getThis();
        }

        abstract B getThis();

        final InstrumentDescriptor buildDescriptor() {
            return InstrumentDescriptor.create(this.name, description, unit, this.instrumentType, this.instrumentValueType);
        }
    }
}

