/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.BatchRecorder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.DoubleCounter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.DoubleUpDownCounter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.DoubleValueRecorder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.Instrument;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.LongCounter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.LongUpDownCounter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.LongValueRecorder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.common.Labels;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

final class BatchRecorderSdk
implements BatchRecorder {
    private final Labels labelSet;
    private final BlockingQueue<Recording> pendingRecordings = new LinkedBlockingQueue<Recording>();

    BatchRecorderSdk(String ... keyValuePairs) {
        this.labelSet = Labels.of(keyValuePairs);
    }

    @Override
    public BatchRecorder put(LongValueRecorder valueRecorder, long value) {
        this.pendingRecordings.offer(new LongRecording(valueRecorder, value));
        return this;
    }

    @Override
    public BatchRecorder put(DoubleValueRecorder valueRecorder, double value) {
        this.pendingRecordings.offer(new DoubleRecording(valueRecorder, value));
        return this;
    }

    @Override
    public BatchRecorder put(LongCounter counter, long value) {
        this.pendingRecordings.offer(new LongRecording(counter, value));
        return this;
    }

    @Override
    public BatchRecorder put(DoubleCounter counter, double value) {
        this.pendingRecordings.offer(new DoubleRecording(counter, value));
        return this;
    }

    @Override
    public BatchRecorder put(LongUpDownCounter upDownCounter, long value) {
        this.pendingRecordings.offer(new LongRecording(upDownCounter, value));
        return this;
    }

    @Override
    public BatchRecorder put(DoubleUpDownCounter upDownCounter, double value) {
        this.pendingRecordings.offer(new DoubleRecording(upDownCounter, value));
        return this;
    }

    @Override
    public void record() {
        ArrayList recordings = new ArrayList();
        this.pendingRecordings.drainTo(recordings);
        for (Recording recording : recordings) {
            Instrument instrument = recording.getInstrument();
            if (instrument instanceof DoubleUpDownCounter) {
                ((DoubleUpDownCounter)instrument).add(recording.getDoubleValue(), this.labelSet);
                continue;
            }
            if (instrument instanceof DoubleCounter) {
                ((DoubleCounter)instrument).add(recording.getDoubleValue(), this.labelSet);
                continue;
            }
            if (instrument instanceof DoubleValueRecorder) {
                ((DoubleValueRecorder)instrument).record(recording.getDoubleValue(), this.labelSet);
                continue;
            }
            if (instrument instanceof LongUpDownCounter) {
                ((LongUpDownCounter)instrument).add(recording.getLongValue(), this.labelSet);
                continue;
            }
            if (instrument instanceof LongCounter) {
                ((LongCounter)instrument).add(recording.getLongValue(), this.labelSet);
                continue;
            }
            if (!(instrument instanceof LongValueRecorder)) continue;
            ((LongValueRecorder)instrument).record(recording.getLongValue(), this.labelSet);
        }
    }

    private static class DoubleRecording
    implements Recording {
        private final Instrument instrument;
        private final double value;

        private DoubleRecording(Instrument instrument, double value) {
            this.instrument = instrument;
            this.value = value;
        }

        @Override
        public Instrument getInstrument() {
            return this.instrument;
        }

        @Override
        public long getLongValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getDoubleValue() {
            return this.value;
        }
    }

    private static class LongRecording
    implements Recording {
        private final Instrument instrument;
        private final long value;

        private LongRecording(Instrument instrument, long value) {
            this.instrument = instrument;
            this.value = value;
        }

        @Override
        public Instrument getInstrument() {
            return this.instrument;
        }

        @Override
        public long getLongValue() {
            return this.value;
        }

        @Override
        public double getDoubleValue() {
            throw new UnsupportedOperationException();
        }
    }

    private static interface Recording {
        public Instrument getInstrument();

        public long getLongValue();

        public double getDoubleValue();
    }
}

