/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.common.Labels;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class InstrumentProcessor<T> {
    private final Aggregator<T> aggregator;
    private final long startEpochNanos;
    private long lastEpochNanos;
    private Map<Labels, T> accumulationMap;

    InstrumentProcessor(Aggregator<T> aggregator, long startEpochNanos) {
        this.aggregator = aggregator;
        this.startEpochNanos = startEpochNanos;
        this.lastEpochNanos = startEpochNanos;
        this.accumulationMap = new HashMap<Labels, T>();
    }

    void batch(Labels labelSet, T accumulation) {
        T currentAccumulation = this.accumulationMap.get(labelSet);
        if (currentAccumulation == null) {
            this.accumulationMap.put(labelSet, accumulation);
            return;
        }
        this.accumulationMap.put(labelSet, this.aggregator.merge(currentAccumulation, accumulation));
    }

    List<MetricData> completeCollectionCycle(long epochNanos) {
        if (this.accumulationMap.isEmpty()) {
            return Collections.emptyList();
        }
        MetricData metricData = this.aggregator.toMetricData(this.accumulationMap, this.startEpochNanos, this.lastEpochNanos, epochNanos);
        this.lastEpochNanos = epochNanos;
        if (!this.aggregator.isStateful()) {
            this.accumulationMap = new HashMap<Labels, T>();
        }
        return metricData == null ? new ArrayList() : Collections.singletonList(metricData);
    }
}

