/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.Meter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.MeterProvider;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.context.Function;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.common.Clock;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.internal.ComponentRegistry;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.SdkMeter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.ViewRegistry;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.MetricData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.export.MetricProducer;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class SdkMeterProvider
extends MeterProvider
implements MetricProducer {
    private static final Logger LOGGER = Logger.getLogger(SdkMeterProvider.class.getName());
    static final String DEFAULT_METER_NAME = "unknown";
    private final ComponentRegistry<SdkMeter> registry;
    private final MeterProviderSharedState sharedState;

    SdkMeterProvider(Clock clock, Resource resource, ViewRegistry viewRegistry) {
        this.sharedState = MeterProviderSharedState.create(clock, resource, viewRegistry);
        this.registry = new ComponentRegistry<SdkMeter>(new Function<InstrumentationLibraryInfo, SdkMeter>(){

            @Override
            public SdkMeter apply(InstrumentationLibraryInfo instrumentationLibraryInfo) {
                return new SdkMeter(SdkMeterProvider.this.sharedState, instrumentationLibraryInfo);
            }
        });
    }

    @Override
    public Meter get(String instrumentationName) {
        return this.get(instrumentationName, null);
    }

    @Override
    public Meter get(String instrumentationName, @Nullable String instrumentationVersion) {
        if (instrumentationName == null || instrumentationName.isEmpty()) {
            LOGGER.fine("Meter requested without instrumentation name.");
            instrumentationName = DEFAULT_METER_NAME;
        }
        return this.registry.get(instrumentationName, instrumentationVersion);
    }

    @Override
    public Collection<MetricData> collectAllMetrics() {
        Collection<SdkMeter> meters = this.registry.getComponents();
        ArrayList<MetricData> result = new ArrayList<MetricData>(meters.size());
        for (SdkMeter meter : meters) {
            result.addAll(meter.collectAll(this.sharedState.getClock().now()));
        }
        return Collections.unmodifiableCollection(result);
    }

    public static SdkMeterProviderBuilder builder() {
        return new SdkMeterProviderBuilder();
    }
}

