/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.GlobalMeterProvider;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.common.Clock;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.internal.SystemClock;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.SdkMeterProvider;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.ViewRegistry;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.ViewRegistryBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.view.InstrumentSelector;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.view.View;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.resources.Resource;
import java.util.HashMap;
import java.util.Map;

public final class SdkMeterProviderBuilder {
    private Clock clock = SystemClock.getInstance();
    private Resource resource = Resource.getDefault();
    private final Map<InstrumentSelector, View> instrumentSelectorViews = new HashMap<InstrumentSelector, View>();

    SdkMeterProviderBuilder() {
    }

    public SdkMeterProviderBuilder setClock(Clock clock) {
        if (clock == null) {
            throw new NullPointerException("clock");
        }
        this.clock = clock;
        return this;
    }

    public SdkMeterProviderBuilder setResource(Resource resource) {
        if (resource == null) {
            throw new NullPointerException("resource");
        }
        this.resource = resource;
        return this;
    }

    public SdkMeterProviderBuilder registerView(InstrumentSelector selector, View view) {
        if (selector == null) {
            throw new NullPointerException("selector");
        }
        if (view == null) {
            throw new NullPointerException("view");
        }
        this.instrumentSelectorViews.put(selector, view);
        return this;
    }

    public SdkMeterProvider buildAndRegisterGlobal() {
        SdkMeterProvider meterProvider = this.build();
        GlobalMeterProvider.set(meterProvider);
        return meterProvider;
    }

    public SdkMeterProvider build() {
        ViewRegistryBuilder viewRegistryBuilder = ViewRegistry.builder();
        for (Map.Entry<InstrumentSelector, View> entry : this.instrumentSelectorViews.entrySet()) {
            viewRegistryBuilder.addView(entry.getKey(), entry.getValue());
        }
        ViewRegistry viewRegistry = viewRegistryBuilder.build();
        return new SdkMeterProvider(this.clock, this.resource, viewRegistry);
    }
}

