/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator;

import com.aliyun.openservices.ons.shaded.com.google.common.util.concurrent.AtomicDouble;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.common.Labels;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator.AbstractSumAggregator;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator.AggregatorHandle;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator.MetricDataUtils;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.DoubleSumData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.MetricData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.resources.Resource;
import java.util.Map;

final class DoubleSumAggregator
extends AbstractSumAggregator<Double> {
    DoubleSumAggregator(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor, AggregationTemporality temporality) {
        super(resource, instrumentationLibraryInfo, descriptor, temporality);
    }

    @Override
    public AggregatorHandle<Double> createHandle() {
        return new Handle();
    }

    @Override
    public Double accumulateDouble(double value) {
        return value;
    }

    @Override
    Double mergeSum(Double previousAccumulation, Double accumulation) {
        return previousAccumulation + accumulation;
    }

    @Override
    Double mergeDiff(Double previousAccumulation, Double accumulation) {
        return accumulation - previousAccumulation;
    }

    @Override
    public MetricData toMetricData(Map<Labels, Double> accumulationByLabels, long startEpochNanos, long lastCollectionEpoch, long epochNanos) {
        return MetricData.createDoubleSum(this.getResource(), this.getInstrumentationLibraryInfo(), this.getInstrumentDescriptor().getName(), this.getInstrumentDescriptor().getDescription(), this.getInstrumentDescriptor().getUnit(), DoubleSumData.create(this.isMonotonic(), this.temporality(), MetricDataUtils.toDoublePointList(accumulationByLabels, this.temporality() == AggregationTemporality.CUMULATIVE ? startEpochNanos : lastCollectionEpoch, epochNanos)));
    }

    static final class Handle
    extends AggregatorHandle<Double> {
        private static final double DEFAULT_VALUE = 0.0;
        private final AtomicDouble current = new AtomicDouble(0.0);

        Handle() {
        }

        @Override
        protected Double doAccumulateThenReset() {
            return this.current.getAndSet(0.0);
        }

        @Override
        protected void doRecordDouble(double value) {
            this.current.getAndAdd(value);
        }
    }
}

