/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data;

import com.aliyun.openservices.ons.shaded.com.google.auto.value.AutoValue;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.AutoValue_MetricData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.Data;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.DoubleGaugeData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.DoubleHistogramData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.DoubleHistogramPointData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.DoublePointData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.DoubleSumData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.DoubleSummaryData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.DoubleSummaryPointData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.LongGaugeData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.LongPointData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.LongSumData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.MetricDataType;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class MetricData {
    private static final DoubleGaugeData DEFAULT_DOUBLE_GAUGE_DATA = DoubleGaugeData.create(new ArrayList<DoublePointData>());
    private static final LongGaugeData DEFAULT_LONG_GAUGE_DATA = LongGaugeData.create(new ArrayList<LongPointData>());
    private static final DoubleSumData DEFAULT_DOUBLE_SUM_DATA = DoubleSumData.create(false, AggregationTemporality.CUMULATIVE, new ArrayList<DoublePointData>());
    private static final LongSumData DEFAULT_LONG_SUM_DATA = LongSumData.create(false, AggregationTemporality.CUMULATIVE, new ArrayList<LongPointData>());
    private static final DoubleSummaryData DEFAULT_DOUBLE_SUMMARY_DATA = DoubleSummaryData.create(new ArrayList<DoubleSummaryPointData>());
    private static final DoubleHistogramData DEFAULT_DOUBLE_HISTOGRAM_DATA = DoubleHistogramData.create(AggregationTemporality.CUMULATIVE, new ArrayList<DoubleHistogramPointData>());

    public static MetricData createDoubleGauge(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, String name, String description, String unit, DoubleGaugeData data) {
        return new AutoValue_MetricData(resource, instrumentationLibraryInfo, name, description, unit, MetricDataType.DOUBLE_GAUGE, data);
    }

    public static MetricData createLongGauge(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, String name, String description, String unit, LongGaugeData data) {
        return new AutoValue_MetricData(resource, instrumentationLibraryInfo, name, description, unit, MetricDataType.LONG_GAUGE, data);
    }

    public static MetricData createDoubleSum(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, String name, String description, String unit, DoubleSumData data) {
        return new AutoValue_MetricData(resource, instrumentationLibraryInfo, name, description, unit, MetricDataType.DOUBLE_SUM, data);
    }

    public static MetricData createLongSum(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, String name, String description, String unit, LongSumData data) {
        return new AutoValue_MetricData(resource, instrumentationLibraryInfo, name, description, unit, MetricDataType.LONG_SUM, data);
    }

    public static MetricData createDoubleSummary(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, String name, String description, String unit, DoubleSummaryData data) {
        return new AutoValue_MetricData(resource, instrumentationLibraryInfo, name, description, unit, MetricDataType.SUMMARY, data);
    }

    public static MetricData createDoubleHistogram(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, String name, String description, String unit, DoubleHistogramData data) {
        return new AutoValue_MetricData(resource, instrumentationLibraryInfo, name, description, unit, MetricDataType.HISTOGRAM, data);
    }

    MetricData() {
    }

    public abstract Resource getResource();

    public abstract InstrumentationLibraryInfo getInstrumentationLibraryInfo();

    public abstract String getName();

    public abstract String getDescription();

    public abstract String getUnit();

    public abstract MetricDataType getType();

    abstract Data<?> getData();

    public boolean isEmpty() {
        return this.getData().getPoints().isEmpty();
    }

    public final DoubleGaugeData getDoubleGaugeData() {
        if (this.getType() == MetricDataType.DOUBLE_GAUGE) {
            return (DoubleGaugeData)this.getData();
        }
        return DEFAULT_DOUBLE_GAUGE_DATA;
    }

    public final LongGaugeData getLongGaugeData() {
        if (this.getType() == MetricDataType.LONG_GAUGE) {
            return (LongGaugeData)this.getData();
        }
        return DEFAULT_LONG_GAUGE_DATA;
    }

    public final DoubleSumData getDoubleSumData() {
        if (this.getType() == MetricDataType.DOUBLE_SUM) {
            return (DoubleSumData)this.getData();
        }
        return DEFAULT_DOUBLE_SUM_DATA;
    }

    public final LongSumData getLongSumData() {
        if (this.getType() == MetricDataType.LONG_SUM) {
            return (LongSumData)this.getData();
        }
        return DEFAULT_LONG_SUM_DATA;
    }

    public final DoubleSummaryData getDoubleSummaryData() {
        if (this.getType() == MetricDataType.SUMMARY) {
            return (DoubleSummaryData)this.getData();
        }
        return DEFAULT_DOUBLE_SUMMARY_DATA;
    }

    public final DoubleHistogramData getDoubleHistogramData() {
        if (this.getType() == MetricDataType.HISTOGRAM) {
            return (DoubleHistogramData)this.getData();
        }
        return DEFAULT_DOUBLE_HISTOGRAM_DATA;
    }
}

