/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.SpanBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.Tracer;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.TracerProvider;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.SdkSpanBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.TracerSharedState;

final class SdkTracer
implements Tracer {
    static final String FALLBACK_SPAN_NAME = "<unspecified span name>";
    private final TracerSharedState sharedState;
    private final InstrumentationLibraryInfo instrumentationLibraryInfo;

    SdkTracer(TracerSharedState sharedState, InstrumentationLibraryInfo instrumentationLibraryInfo) {
        this.sharedState = sharedState;
        this.instrumentationLibraryInfo = instrumentationLibraryInfo;
    }

    @Override
    public SpanBuilder spanBuilder(String spanName) {
        if (spanName == null || spanName.trim().isEmpty()) {
            spanName = FALLBACK_SPAN_NAME;
        }
        if (this.sharedState.hasBeenShutdown()) {
            return TracerProvider.noop().get(this.instrumentationLibraryInfo.getName(), this.instrumentationLibraryInfo.getVersion()).spanBuilder(spanName);
        }
        return new SdkSpanBuilder(spanName, this.instrumentationLibraryInfo, this.sharedState, this.sharedState.getSpanLimits());
    }

    InstrumentationLibraryInfo getInstrumentationLibraryInfo() {
        return this.instrumentationLibraryInfo;
    }
}

