/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.common.Clock;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.internal.SystemClock;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.resources.Resource;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.IdGenerator;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.SdkTracerProvider;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.SpanLimits;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.SpanProcessor;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.Supplier;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.samplers.Sampler;
import java.util.ArrayList;
import java.util.List;

public final class SdkTracerProviderBuilder {
    private static final Sampler DEFAULT_SAMPLER = Sampler.parentBased(Sampler.alwaysOn());
    private final List<SpanProcessor> spanProcessors = new ArrayList<SpanProcessor>();
    private Clock clock = SystemClock.getInstance();
    private IdGenerator idsGenerator = IdGenerator.random();
    private Resource resource = Resource.getDefault();
    private Supplier<SpanLimits> spanLimitsSupplier = new Supplier<SpanLimits>(){

        @Override
        public SpanLimits get() {
            return SpanLimits.getDefault();
        }
    };
    private Sampler sampler = DEFAULT_SAMPLER;

    public SdkTracerProviderBuilder setClock(Clock clock) {
        if (clock == null) {
            throw new NullPointerException("clock");
        }
        this.clock = clock;
        return this;
    }

    public SdkTracerProviderBuilder setIdGenerator(IdGenerator idGenerator) {
        if (idGenerator == null) {
            throw new NullPointerException("idGenerator");
        }
        this.idsGenerator = idGenerator;
        return this;
    }

    public SdkTracerProviderBuilder setResource(Resource resource) {
        if (resource == null) {
            throw new NullPointerException("resource");
        }
        this.resource = resource;
        return this;
    }

    public SdkTracerProviderBuilder setSpanLimits(final SpanLimits spanLimits) {
        if (spanLimits == null) {
            throw new NullPointerException("spanLimits");
        }
        this.spanLimitsSupplier = new Supplier<SpanLimits>(){

            @Override
            public SpanLimits get() {
                return spanLimits;
            }
        };
        return this;
    }

    public SdkTracerProviderBuilder setSpanLimits(Supplier<SpanLimits> spanLimitsSupplier) {
        if (spanLimitsSupplier == null) {
            throw new NullPointerException("spanLimitsSupplier");
        }
        this.spanLimitsSupplier = spanLimitsSupplier;
        return this;
    }

    public SdkTracerProviderBuilder setSampler(Sampler sampler) {
        if (sampler == null) {
            throw new NullPointerException("sampler");
        }
        this.sampler = sampler;
        return this;
    }

    public SdkTracerProviderBuilder addSpanProcessor(SpanProcessor spanProcessor) {
        this.spanProcessors.add(spanProcessor);
        return this;
    }

    public SdkTracerProvider build() {
        return new SdkTracerProvider(this.clock, this.idsGenerator, this.resource, this.spanLimitsSupplier, this.sampler, this.spanProcessors);
    }

    SdkTracerProviderBuilder() {
    }
}

