/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.context.Context;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.common.CompletableResultCode;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.MultiSpanProcessor;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.NoopSpanProcessor;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.ReadWriteSpan;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.ReadableSpan;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class SpanProcessor {
    public static SpanProcessor composite(SpanProcessor ... processors) {
        return SpanProcessor.composite(Arrays.asList(processors));
    }

    public static SpanProcessor composite(Iterable<SpanProcessor> processors) {
        ArrayList<SpanProcessor> processorsList = new ArrayList<SpanProcessor>();
        for (SpanProcessor processor : processors) {
            processorsList.add(processor);
        }
        if (processorsList.isEmpty()) {
            return NoopSpanProcessor.getInstance();
        }
        if (processorsList.size() == 1) {
            return (SpanProcessor)processorsList.get(0);
        }
        return MultiSpanProcessor.create(processorsList);
    }

    public abstract void onStart(Context var1, ReadWriteSpan var2);

    public abstract boolean isStartRequired();

    public abstract void onEnd(ReadableSpan var1);

    public abstract boolean isEndRequired();

    public CompletableResultCode shutdown() {
        return this.forceFlush();
    }

    public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofSuccess();
    }

    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }
}

