/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.data;

import com.aliyun.openservices.ons.shaded.com.google.auto.value.AutoValue;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.StatusCode;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.data.AutoValue_ImmutableStatusData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.data.StatusData;
import java.util.EnumMap;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
abstract class ImmutableStatusData
extends StatusData {
    static final StatusData OK;
    static final StatusData UNSET;
    static final StatusData ERROR;
    static final EnumMap<StatusCode, StatusData> codeToStatus;

    ImmutableStatusData() {
    }

    public static StatusData create(StatusCode statusCode, String description) {
        if (description == null || description.isEmpty()) {
            return codeToStatus.get((Object)statusCode);
        }
        return ImmutableStatusData.createInternal(statusCode, description);
    }

    private static StatusData createInternal(StatusCode statusCode, String description) {
        return new AutoValue_ImmutableStatusData(statusCode, description);
    }

    static {
        StatusCode[] codes;
        OK = ImmutableStatusData.createInternal(StatusCode.OK, "");
        UNSET = ImmutableStatusData.createInternal(StatusCode.UNSET, "");
        ERROR = ImmutableStatusData.createInternal(StatusCode.ERROR, "");
        codeToStatus = new EnumMap(StatusCode.class);
        codeToStatus.put(StatusCode.UNSET, StatusData.unset());
        codeToStatus.put(StatusCode.OK, StatusData.ok());
        codeToStatus.put(StatusCode.ERROR, StatusData.error());
        for (StatusCode code : codes = StatusCode.values()) {
            StatusData status = codeToStatus.get((Object)code);
            if (status != null) continue;
            codeToStatus.put(code, ImmutableStatusData.createInternal(code, ""));
        }
    }
}

