/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.impl;

import com.aliyun.openservices.ons.shaded.com.google.common.base.Preconditions;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.exception.ClientException;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.misc.Validators;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.remoting.CredentialsProvider;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.utility.UtilAll;

public class ClientConfig {
    public static final String DEFAULT_REGION_ID = "unknown";
    public static final String DEFAULT_SERVICE_NAME = "RocketMQ";
    private static final String CLIENT_ID_SEPARATOR = "@";
    protected long ioTimeoutMillis = 3000L;
    protected final String id;
    protected String group;
    protected String nameServerStr;
    protected String namespace = "";
    protected boolean tracingEnabled = true;
    private String regionId = "unknown";
    private String serviceName = "RocketMQ";
    private String tenantId = "";
    private volatile CredentialsProvider credentialsProvider = null;

    public ClientConfig(String group) throws ClientException {
        Validators.checkGroup(group);
        this.group = Preconditions.checkNotNull(group, "group");
        StringBuilder sb = new StringBuilder();
        String hostName = UtilAll.hostName();
        sb.append(hostName);
        sb.append(CLIENT_ID_SEPARATOR);
        sb.append(UtilAll.processId());
        sb.append(CLIENT_ID_SEPARATOR);
        sb.append(Long.toString(System.nanoTime(), 36));
        this.id = sb.toString();
    }

    public void setGroup(String group) throws ClientException {
        Validators.checkGroup(group);
        this.group = Preconditions.checkNotNull(group, "group");
    }

    public String getGroup() {
        return this.group;
    }

    public void setNamespace(String namespace) {
        this.namespace = Preconditions.checkNotNull(namespace, "namespace");
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        Preconditions.checkNotNull(credentialsProvider, "credentialsProvider");
        this.credentialsProvider = credentialsProvider;
    }

    public long getIoTimeoutMillis() {
        return this.ioTimeoutMillis;
    }

    public String getId() {
        return this.id;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isTracingEnabled() {
        return this.tracingEnabled;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public void setIoTimeoutMillis(long ioTimeoutMillis) {
        this.ioTimeoutMillis = ioTimeoutMillis;
    }

    public void setTracingEnabled(boolean tracingEnabled) {
        this.tracingEnabled = tracingEnabled;
    }

    public boolean getTracingEnabled() {
        return this.tracingEnabled;
    }

    void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getNameServerStr() {
        return this.nameServerStr;
    }
}

