/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message;

import com.aliyun.openservices.ons.shaded.com.google.common.base.Joiner;
import com.aliyun.openservices.ons.shaded.com.google.common.base.MoreObjects;
import com.aliyun.openservices.ons.shaded.com.google.common.base.Objects;
import com.aliyun.openservices.ons.shaded.com.google.common.base.Preconditions;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageExt;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageIdGenerator;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageImpl;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.protocol.MessageType;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.protocol.SystemAttribute;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.utility.UtilAll;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Message {
    final MessageImpl impl;
    private final MessageExt messageExt;

    public Message(String topic, String tag, byte[] body) {
        SystemAttribute systemAttribute = new SystemAttribute();
        ConcurrentHashMap<String, String> userAttribute = new ConcurrentHashMap<String, String>();
        systemAttribute.setTag(tag);
        systemAttribute.setBornHost(UtilAll.hostName());
        this.impl = new MessageImpl(topic, systemAttribute, userAttribute, body);
        this.reset();
        this.messageExt = new MessageExt(this.impl);
    }

    public Message(MessageImpl impl) {
        this.impl = impl;
        this.messageExt = new MessageExt(impl);
    }

    public void setTopic(String topic) {
        this.impl.setTopic(Preconditions.checkNotNull(topic, "topic"));
        this.reset();
    }

    public String getTopic() {
        return this.impl.getTopic();
    }

    public void setTag(String tag) {
        this.impl.getSystemAttribute().setTag(tag);
        this.reset();
    }

    public String getTag() {
        return this.impl.getSystemAttribute().getTag();
    }

    public void putUserProperty(String name, String value) {
        this.impl.getUserAttribute().put(name, value);
        this.reset();
    }

    public String getUserProperty(String name) {
        return (String)this.impl.getUserAttribute().get(name);
    }

    public void setKeys(Collection<String> keys) {
        Preconditions.checkNotNull(keys, "keys");
        SystemAttribute systemAttribute = this.impl.getSystemAttribute();
        List<String> keyList = systemAttribute.getKeyList();
        keyList.clear();
        keyList.addAll(keys);
        this.reset();
    }

    public String getKeys() {
        Joiner joiner = Joiner.on(" ");
        return joiner.join(this.impl.getSystemAttribute().getKeyList());
    }

    public List<String> getKeysList() {
        return this.impl.getSystemAttribute().getKeyList();
    }

    public int getDelayTimeLevel() {
        return this.impl.getSystemAttribute().getDelayLevel();
    }

    public void setDelayTimeLevel(int level) {
        SystemAttribute systemAttribute = this.impl.getSystemAttribute();
        systemAttribute.setDelayLevel(level);
        this.reset();
    }

    public void setDeliveryTimestamp(long deliveryTimestamp) {
        SystemAttribute systemAttribute = this.impl.getSystemAttribute();
        systemAttribute.setDeliveryTimeMillis(deliveryTimestamp);
        systemAttribute.setMessageType(MessageType.DELAY);
        this.reset();
    }

    public long getDelayTimeMillis() {
        return this.impl.getSystemAttribute().getDeliveryTimeMillis();
    }

    public void setBody(byte[] body) {
        this.impl.setBody(body);
        this.reset();
    }

    public byte[] getBody() {
        return this.impl.getBody();
    }

    public Map<String, String> getUserProperties() {
        return this.impl.getUserAttribute();
    }

    public String getMessageGroup() {
        return this.impl.getSystemAttribute().getMessageGroup();
    }

    public String getMsgId() {
        return this.impl.getSystemAttribute().getMessageId();
    }

    public long getBornTimeMillis() {
        return this.impl.getSystemAttribute().getBornTimeMillis();
    }

    public String getBornHost() {
        return this.impl.getSystemAttribute().getBornHost();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        return Objects.equal(this.impl, message.impl);
    }

    public int hashCode() {
        return Objects.hashCode(this.impl);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("impl", this.impl).toString();
    }

    public MessageExt getMessageExt() {
        return this.messageExt;
    }

    private void reset() {
        this.impl.getSystemAttribute().setBornTimeMillis(System.currentTimeMillis());
        this.impl.getSystemAttribute().setMessageId(MessageIdGenerator.getInstance().next());
    }
}

