/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message;

import com.aliyun.openservices.ons.shaded.com.google.common.base.Joiner;
import com.aliyun.openservices.ons.shaded.com.google.common.base.MoreObjects;
import com.aliyun.openservices.ons.shaded.com.google.common.base.Objects;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageImpl;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.protocol.MessageType;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.route.Endpoints;
import java.util.Map;

public class MessageExt {
    protected final MessageImpl impl;

    public MessageExt(MessageImpl impl) {
        this.impl = impl;
    }

    public byte[] getBody() {
        return this.impl.getBody();
    }

    public String getTopic() {
        return this.impl.getTopic();
    }

    public String getTag() {
        return this.impl.getSystemAttribute().getTag();
    }

    public String getKeys() {
        Joiner joiner = Joiner.on(" ");
        return joiner.join(this.impl.getSystemAttribute().getKeyList());
    }

    public int getDelayTimeLevel() {
        return this.impl.getSystemAttribute().getDelayLevel();
    }

    public long getDeliveryTimestamp() {
        return this.impl.getSystemAttribute().getDeliveryTimeMillis();
    }

    public int getQueueId() {
        return this.impl.getSystemAttribute().getPartitionId();
    }

    public long getBornTimestamp() {
        return this.impl.getSystemAttribute().getBornTimeMillis();
    }

    public String getBornHost() {
        return this.impl.getSystemAttribute().getBornHost();
    }

    public long getQueueOffset() {
        return this.impl.getSystemAttribute().getPartitionOffset();
    }

    public String getMsgId() {
        return this.impl.getSystemAttribute().getMessageId();
    }

    public long getDecodedTimestamp() {
        return this.impl.getSystemAttribute().getDecodedTimestamp();
    }

    public int getReconsumeTimes() {
        return this.impl.getSystemAttribute().getDeliveryAttempt() - 1;
    }

    public int getDeliveryAttempt() {
        return this.impl.getSystemAttribute().getDeliveryAttempt();
    }

    public String getReceiptHandle() {
        return this.impl.getSystemAttribute().getReceiptHandle();
    }

    public String getMessageGroup() {
        return this.impl.getSystemAttribute().getMessageGroup();
    }

    public long getStoreTimestamp() {
        return this.impl.getSystemAttribute().getStoreTimeMillis();
    }

    public Endpoints getEndpoints() {
        return this.impl.getSystemAttribute().getEndpoints();
    }

    public String getTraceContext() {
        return this.impl.getSystemAttribute().getTraceContext();
    }

    public Map<String, String> getUserProperties() {
        return this.impl.getUserAttribute();
    }

    public MessageType getMsgType() {
        switch (this.impl.getSystemAttribute().getMessageType()) {
            case FIFO: {
                return MessageType.FIFO;
            }
            case DELAY: {
                return MessageType.DELAY;
            }
            case TRANSACTION: {
                return MessageType.TRANSACTION;
            }
        }
        return MessageType.NORMAL;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageExt that = (MessageExt)o;
        return Objects.equal(this.impl, that.impl);
    }

    public int hashCode() {
        return Objects.hashCode(this.impl);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("impl", this.impl).toString();
    }
}

