/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message;

import com.aliyun.openservices.ons.shaded.com.google.common.base.MoreObjects;
import com.aliyun.openservices.ons.shaded.com.google.common.base.Objects;
import com.aliyun.openservices.ons.shaded.com.google.common.base.Preconditions;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.protocol.SystemAttribute;
import java.util.Arrays;
import java.util.concurrent.ConcurrentMap;

public class MessageImpl {
    private String topic;
    private final SystemAttribute systemAttribute;
    private final ConcurrentMap<String, String> userAttribute;
    private byte[] body;
    private final boolean corrupted;

    public MessageImpl(String topic, SystemAttribute systemAttribute, ConcurrentMap<String, String> userAttribute, byte[] body) {
        this(topic, systemAttribute, userAttribute, body, false);
    }

    public MessageImpl(String topic, SystemAttribute systemAttribute, ConcurrentMap<String, String> userAttribute, byte[] body, boolean corrupted) {
        this.topic = Preconditions.checkNotNull(topic, "topic");
        this.systemAttribute = Preconditions.checkNotNull(systemAttribute, "systemAttribute");
        this.userAttribute = Preconditions.checkNotNull(userAttribute, "userAttribute");
        this.body = Preconditions.checkNotNull(body, "body");
        this.corrupted = corrupted;
    }

    public void setBody(byte[] body) {
        this.body = (byte[])Preconditions.checkNotNull(body, "body").clone();
    }

    public byte[] getBody() {
        return (byte[])this.body.clone();
    }

    public String getTopic() {
        return this.topic;
    }

    public SystemAttribute getSystemAttribute() {
        return this.systemAttribute;
    }

    public ConcurrentMap<String, String> getUserAttribute() {
        return this.userAttribute;
    }

    public boolean isCorrupted() {
        return this.corrupted;
    }

    public void setTopic(String topic) {
        this.topic = Preconditions.checkNotNull(topic, "topic");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageImpl message = (MessageImpl)o;
        return this.corrupted == message.corrupted && Objects.equal(this.topic, message.topic) && Objects.equal(this.systemAttribute, message.systemAttribute) && Objects.equal(this.userAttribute, message.userAttribute) && Arrays.equals(this.body, message.getBody());
    }

    public int hashCode() {
        return Objects.hashCode(this.topic, this.systemAttribute, this.userAttribute, Arrays.hashCode(this.body), this.corrupted);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("topic", this.topic).add("systemAttribute", this.systemAttribute).add("userAttribute", this.userAttribute).add("body", this.body).add("corrupted", this.corrupted).toString();
    }
}

