/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message;

import com.aliyun.openservices.ons.shaded.com.google.protobuf.util.Durations;
import com.aliyun.openservices.ons.shaded.com.google.protobuf.util.Timestamps;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.Message;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageExt;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageImpl;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.protocol.Digest;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.protocol.DigestType;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.protocol.Encoding;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.protocol.MessageType;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.protocol.SystemAttribute;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.utility.UtilAll;
import com.aliyun.openservices.ons.shaded.org.slf4j.Logger;
import com.aliyun.openservices.ons.shaded.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;

public class MessageImplAccessor {
    private static final Logger log = LoggerFactory.getLogger(MessageImplAccessor.class);

    private MessageImplAccessor() {
    }

    public static MessageImpl getMessageImpl(Message message) {
        return message.impl;
    }

    public static MessageImpl getMessageImpl(MessageExt messageExt) {
        return messageExt.impl;
    }

    public static MessageImpl wrapMessageImpl(apache.rocketmq.v1.Message message) {
        MessageType messageType;
        SystemAttribute mqSystemAttribute = new SystemAttribute();
        apache.rocketmq.v1.SystemAttribute systemAttribute = message.getSystemAttribute();
        mqSystemAttribute.setTag(systemAttribute.getTag());
        ArrayList<String> keyList = new ArrayList<String>(systemAttribute.getKeysList());
        mqSystemAttribute.setKeyList(keyList);
        String messageId = systemAttribute.getMessageId();
        mqSystemAttribute.setMessageId(messageId);
        apache.rocketmq.v1.Digest bodyDigest = systemAttribute.getBodyDigest();
        byte[] body = message.getBody().toByteArray();
        boolean corrupted = false;
        DigestType digestType = DigestType.CRC32;
        String checksum = bodyDigest.getChecksum();
        switch (bodyDigest.getType()) {
            case CRC32: {
                String expectedCheckSum = UtilAll.crc32CheckSum(body);
                if (expectedCheckSum.equals(checksum)) break;
                corrupted = true;
                break;
            }
            case MD5: {
                try {
                    String expectedCheckSum = UtilAll.md5CheckSum(body);
                    if (expectedCheckSum.equals(checksum)) break;
                    corrupted = true;
                }
                catch (NoSuchAlgorithmException e) {
                    corrupted = true;
                    log.warn("MD5 is not supported unexpectedly, skip it, messageId={}", (Object)messageId);
                }
                break;
            }
            case SHA1: {
                try {
                    String expectedCheckSum = UtilAll.sha1CheckSum(body);
                    if (expectedCheckSum.equals(checksum)) break;
                    corrupted = true;
                }
                catch (NoSuchAlgorithmException e) {
                    corrupted = true;
                    log.warn("SHA-1 is not supported unexpectedly, skip it, messageId={}", (Object)messageId);
                }
                break;
            }
            default: {
                log.warn("Unsupported message body digest algorithm.");
            }
        }
        mqSystemAttribute.setDigest(new Digest(digestType, checksum));
        switch (systemAttribute.getBodyEncoding()) {
            case GZIP: {
                try {
                    body = UtilAll.uncompressBytesGzip(body);
                    mqSystemAttribute.setBodyEncoding(Encoding.GZIP);
                }
                catch (IOException e) {
                    log.error("Failed to uncompress message body, messageId={}", (Object)messageId);
                    corrupted = true;
                }
                break;
            }
            case IDENTITY: {
                mqSystemAttribute.setBodyEncoding(Encoding.IDENTITY);
                break;
            }
            default: {
                log.warn("Unsupported message encoding algorithm.");
            }
        }
        switch (systemAttribute.getMessageType()) {
            case NORMAL: {
                messageType = MessageType.NORMAL;
                break;
            }
            case FIFO: {
                messageType = MessageType.FIFO;
                break;
            }
            case DELAY: {
                messageType = MessageType.DELAY;
                break;
            }
            case TRANSACTION: {
                messageType = MessageType.TRANSACTION;
                break;
            }
            default: {
                messageType = MessageType.NORMAL;
                log.warn("Unknown message type, fall through to normal type");
            }
        }
        mqSystemAttribute.setMessageType(messageType);
        mqSystemAttribute.setBornTimeMillis(Timestamps.toMillis(systemAttribute.getBornTimestamp()));
        mqSystemAttribute.setBornHost(systemAttribute.getBornHost());
        mqSystemAttribute.setStoreTimeMillis(Timestamps.toMillis(systemAttribute.getStoreTimestamp()));
        switch (systemAttribute.getTimedDeliveryCase()) {
            case DELAY_LEVEL: {
                mqSystemAttribute.setDelayLevel(systemAttribute.getDelayLevel());
                break;
            }
            case DELIVERY_TIMESTAMP: {
                mqSystemAttribute.setDeliveryTimeMillis(Timestamps.toMillis(systemAttribute.getDeliveryTimestamp()));
                break;
            }
        }
        mqSystemAttribute.setReceiptHandle(systemAttribute.getReceiptHandle());
        mqSystemAttribute.setPartitionId(systemAttribute.getPartitionId());
        mqSystemAttribute.setPartitionOffset(systemAttribute.getPartitionOffset());
        mqSystemAttribute.setInvisiblePeriod(Durations.toMillis(systemAttribute.getInvisiblePeriod()));
        mqSystemAttribute.setDeliveryAttempt(systemAttribute.getDeliveryAttempt());
        mqSystemAttribute.setProducerGroup(systemAttribute.getProducerGroup().getName());
        mqSystemAttribute.setMessageGroup(systemAttribute.getMessageGroup());
        mqSystemAttribute.setTraceContext(systemAttribute.getTraceContext());
        mqSystemAttribute.setOrphanedTransactionRecoveryPeriodMillis(Durations.toMillis(systemAttribute.getOrphanedTransactionRecoveryPeriod()));
        mqSystemAttribute.setDecodedTimestamp(System.currentTimeMillis());
        ConcurrentHashMap<String, String> mqUserAttribute = new ConcurrentHashMap<String, String>(message.getUserAttributeMap());
        String topic = message.getTopic().getName();
        return new MessageImpl(topic, mqSystemAttribute, mqUserAttribute, body, corrupted);
    }
}

