/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message;

import com.aliyun.openservices.ons.shaded.com.google.common.base.Objects;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.route.Partition;

public class MessageQueue {
    private final String topic;
    private final String brokerName;
    private final int queueId;
    private final transient Partition partition;

    public MessageQueue(Partition partition) {
        this.topic = partition.getTopicResource().getName();
        this.brokerName = partition.getBroker().getName();
        this.queueId = partition.getId();
        this.partition = partition;
    }

    @Deprecated
    public MessageQueue(String topic, String brokerName, int queueId) {
        this.topic = topic;
        this.brokerName = brokerName;
        this.queueId = queueId;
        this.partition = null;
    }

    public String toString() {
        return this.topic + "." + this.brokerName + "." + this.queueId;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public int getQueueId() {
        return this.queueId;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageQueue that = (MessageQueue)o;
        if (null == this.partition || null == ((MessageQueue)o).getPartition()) {
            return this.queueId == that.queueId && Objects.equal(this.topic, that.topic) && Objects.equal(this.brokerName, that.brokerName);
        }
        return this.queueId == that.queueId && Objects.equal(this.topic, that.topic) && Objects.equal(this.brokerName, that.brokerName) && Objects.equal(this.partition, that.partition);
    }

    public int hashCode() {
        return Objects.hashCode(this.topic, this.brokerName, this.queueId);
    }
}

