/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.misc;

import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.route.Address;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.route.AddressScheme;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.route.Endpoints;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.utility.HttpTinyClient;
import com.aliyun.openservices.ons.shaded.org.slf4j.Logger;
import com.aliyun.openservices.ons.shaded.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TopAddressing {
    private static final Logger log = LoggerFactory.getLogger(TopAddressing.class);
    private static final int HTTP_TIMEOUT_MILLIS = 3000;
    private static final String DEFAULT_NAME_SERVER_DOMAIN = "jmenv.tbsite.net";
    private static final String DEFAULT_NAME_SERVER_SUB_GROUP = "nsaddr";
    private final String wsAddress = this.getWsAddress();
    private String unitName;

    private String getWsAddress() {
        return "http://jmenv.tbsite.net:8080/rocketmq/nsaddr";
    }

    public List<Endpoints> fetchNameServerAddresses() throws IOException {
        ArrayList<Endpoints> endpointsList = new ArrayList<Endpoints>();
        HttpTinyClient.HttpResult httpResult = HttpTinyClient.getInstance().httpGet(this.wsAddress, 3000);
        if (httpResult.isOk()) {
            String[] nameServerAddresses;
            String content = httpResult.getContent();
            for (String nameServerAddress : nameServerAddresses = content.split(";")) {
                ArrayList<Address> addresses = new ArrayList<Address>();
                String[] split = nameServerAddress.split(":");
                String host = split[0];
                int port = Integer.parseInt(split[1]);
                addresses.add(new Address(host, port));
                endpointsList.add(new Endpoints(AddressScheme.IPv4, addresses));
            }
            return endpointsList;
        }
        log.error("Failed to name server addresses from topAddress, httpCode={}", (Object)httpResult.getCode());
        return endpointsList;
    }
}

