/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.remoting;

import com.aliyun.openservices.ons.shaded.io.grpc.CallOptions;
import com.aliyun.openservices.ons.shaded.io.grpc.Channel;
import com.aliyun.openservices.ons.shaded.io.grpc.ClientCall;
import com.aliyun.openservices.ons.shaded.io.grpc.ClientInterceptor;
import com.aliyun.openservices.ons.shaded.io.grpc.ForwardingClientCall;
import com.aliyun.openservices.ons.shaded.io.grpc.Metadata;
import com.aliyun.openservices.ons.shaded.io.grpc.MethodDescriptor;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.impl.ClientConfig;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.impl.Signature;
import com.aliyun.openservices.ons.shaded.org.slf4j.Logger;
import com.aliyun.openservices.ons.shaded.org.slf4j.LoggerFactory;

public class AuthInterceptor
implements ClientInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthInterceptor.class);
    private final ClientConfig clientConfig;

    public AuthInterceptor(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    private void customMetadata(Metadata headers) {
        try {
            Metadata metadata = Signature.sign(this.clientConfig);
            headers.merge(metadata);
        }
        catch (Throwable t) {
            log.error("Failed to sign headers", t);
        }
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            @Override
            public void start(ClientCall.Listener<RespT> listener, Metadata headers) {
                AuthInterceptor.this.customMetadata(headers);
                super.start(listener, headers);
            }
        };
    }
}

