/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.remoting;

import com.aliyun.openservices.ons.shaded.com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Credentials {
    private static final long TOLERANCE_MILLIS = 1000L;
    private final String accessKey;
    private final String accessSecret;
    private final String securityToken;
    private final long expiredTimeMillis;

    public Credentials(String accessKey, String accessSecret) {
        this.accessKey = Preconditions.checkNotNull(accessKey, "accessKey");
        this.accessSecret = Preconditions.checkNotNull(accessSecret, "accessSecret");
        this.securityToken = null;
        this.expiredTimeMillis = Long.MAX_VALUE;
    }

    public Credentials(String accessKey, String accessSecret, String securityToken) {
        this.accessKey = Preconditions.checkNotNull(accessKey, "accessKey");
        this.accessSecret = Preconditions.checkNotNull(accessSecret, "accessSecret");
        this.securityToken = Preconditions.checkNotNull(securityToken, "securityToken");
        this.expiredTimeMillis = Long.MAX_VALUE;
    }

    public Credentials(String accessKey, String accessSecret, String securityToken, long expiredTimeMillis) {
        this.accessKey = Preconditions.checkNotNull(accessKey, "accessKey");
        this.accessSecret = Preconditions.checkNotNull(accessSecret, "accessSecret");
        this.securityToken = Preconditions.checkNotNull(securityToken, "securityToken");
        this.expiredTimeMillis = expiredTimeMillis;
    }

    public boolean expiredSoon() {
        return System.currentTimeMillis() + 1000L > this.expiredTimeMillis;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getAccessSecret() {
        return this.accessSecret;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }
}

