/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.trace;

import com.aliyun.openservices.ons.shaded.com.google.common.annotations.VisibleForTesting;
import com.aliyun.openservices.ons.shaded.commons.lang3.StringUtils;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.common.Attributes;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.common.AttributesBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.resources.Resource;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.trace.ResourceAttributes;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.utility.MetadataUtils;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.utility.UtilAll;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;

public class TraceResource {
    private static final String SERVICE_NAME = "rocketmq-client";
    private static final Resource INSTANCE = TraceResource.buildResource();

    private TraceResource() {
    }

    public static Resource get() {
        return INSTANCE;
    }

    @VisibleForTesting
    static Resource buildResource() {
        AttributesBuilder attributesBuilder = Attributes.builder();
        Attributes defaultAttributes = Resource.getDefault().getAttributes();
        attributesBuilder.putAll(defaultAttributes);
        attributesBuilder.put(ResourceAttributes.SERVICE_NAME, SERVICE_NAME);
        attributesBuilder.put(ResourceAttributes.SERVICE_VERSION, MetadataUtils.getVersion());
        attributesBuilder.put(ResourceAttributes.HOST_NAME, UtilAll.hostName());
        Attributes osAttributes = TraceResource.buildOsAttributes();
        Attributes processAttributes = TraceResource.buildProcessAttributes();
        attributesBuilder.putAll(osAttributes);
        attributesBuilder.putAll(processAttributes);
        return Resource.create(attributesBuilder.build());
    }

    static Attributes buildOsAttributes() {
        String version;
        AttributesBuilder attributesBuilder = Attributes.builder();
        String osName = UtilAll.getOsName();
        if (null == osName) {
            return attributesBuilder.build();
        }
        String osSimplifiedName = TraceResource.getOsSimplifiedName(osName);
        if (null != osSimplifiedName) {
            attributesBuilder.put(ResourceAttributes.OS_TYPE, osSimplifiedName);
        }
        String osDescription = null != (version = UtilAll.getOsVersion()) ? osName + ' ' + version : osName;
        attributesBuilder.put(ResourceAttributes.OS_DESCRIPTION, osDescription);
        return attributesBuilder.build();
    }

    static Attributes buildProcessAttributes() {
        AttributesBuilder attributesBuilder = Attributes.builder();
        try {
            long processId = UtilAll.processId();
            String name = System.getProperty("java.runtime.name");
            String version = System.getProperty("java.runtime.version");
            String description = System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version");
            attributesBuilder.put(ResourceAttributes.PROCESS_PID, Long.valueOf(processId));
            attributesBuilder.put(ResourceAttributes.PROCESS_RUNTIME_NAME, name);
            attributesBuilder.put(ResourceAttributes.PROCESS_RUNTIME_VERSION, version);
            attributesBuilder.put(ResourceAttributes.PROCESS_RUNTIME_DESCRIPTION, description);
            String javaHome = UtilAll.getJavaHome();
            String osName = UtilAll.getOsName();
            if (javaHome != null) {
                StringBuilder executablePath = new StringBuilder(javaHome);
                executablePath.append(File.pathSeparatorChar).append("bin").append(File.pathSeparatorChar).append("java");
                if (null != osName && osName.toLowerCase(UtilAll.LOCALE).startsWith("windows")) {
                    executablePath.append(".exe");
                }
                attributesBuilder.put(ResourceAttributes.PROCESS_EXECUTABLE_PATH, executablePath.toString());
                RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
                StringBuilder commandLine = new StringBuilder(executablePath);
                for (String arg : runtime.getInputArguments()) {
                    if (StringUtils.startsWith(arg, "-D")) continue;
                    commandLine.append(' ').append(arg);
                }
                attributesBuilder.put(ResourceAttributes.PROCESS_FILTERED_COMMAND_LINE, commandLine.toString());
                attributesBuilder.build();
            }
            return attributesBuilder.build();
        }
        catch (SecurityException ignore) {
            return attributesBuilder.build();
        }
    }

    private static String getOsSimplifiedName(String os) {
        if ((os = os.toLowerCase(UtilAll.LOCALE)).startsWith("windows")) {
            return "windows";
        }
        if (os.startsWith("linux")) {
            return "linux";
        }
        if (os.startsWith("mac")) {
            return "darwin";
        }
        if (os.startsWith("freebsd")) {
            return "freebsd";
        }
        if (os.startsWith("netbsd")) {
            return "netbsd";
        }
        if (os.startsWith("openbsd")) {
            return "openbsd";
        }
        if (os.startsWith("dragonflybsd")) {
            return "dragonflybsd";
        }
        if (os.startsWith("hp-ux")) {
            return "hpux";
        }
        if (os.startsWith("aix")) {
            return "aix";
        }
        if (os.startsWith("solaris")) {
            return "solaris";
        }
        if (os.startsWith("z/os")) {
            return "z_os";
        }
        return null;
    }
}

