/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.utility;

import com.aliyun.openservices.ons.shaded.com.google.common.util.concurrent.ListenableFuture;
import com.aliyun.openservices.ons.shaded.com.google.common.util.concurrent.SettableFuture;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutorService;

public class HttpTinyClient {
    private static final String GET_METHOD = "GET";
    private static final HttpTinyClient INSTANCE = new HttpTinyClient();

    private HttpTinyClient() {
    }

    public static HttpTinyClient getInstance() {
        return INSTANCE;
    }

    public ListenableFuture<HttpResult> httpGet(final String url, final int timeoutMillis, ExecutorService executor) {
        final SettableFuture<HttpResult> future0 = SettableFuture.create();
        try {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        HttpResult httpResult = HttpTinyClient.this.httpGet(url, timeoutMillis);
                        future0.set(httpResult);
                    }
                    catch (Throwable t) {
                        future0.setException(t);
                    }
                }
            });
        }
        catch (Throwable t) {
            future0.setException(t);
        }
        return future0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResult httpGet(String url, int timeoutMillis) throws IOException {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setRequestMethod(GET_METHOD);
            conn.setConnectTimeout(timeoutMillis);
            conn.setReadTimeout(timeoutMillis);
            conn.connect();
            int respCode = conn.getResponseCode();
            String resp = 200 == respCode ? HttpTinyClient.toString(conn.getInputStream(), "UTF-8") : HttpTinyClient.toString(conn.getErrorStream(), "UTF-8");
            HttpResult httpResult = new HttpResult(respCode, resp);
            return httpResult;
        }
        finally {
            if (null != conn) {
                conn.disconnect();
            }
        }
    }

    public static String toString(InputStream input, String encoding) throws IOException {
        return null == encoding ? HttpTinyClient.toString(new InputStreamReader(input, "UTF-8")) : HttpTinyClient.toString(new InputStreamReader(input, encoding));
    }

    public static String toString(Reader reader) throws IOException {
        CharArrayWriter sw = new CharArrayWriter();
        HttpTinyClient.copy(reader, sw);
        return sw.toString();
    }

    public static void copy(Reader input, Writer output) throws IOException {
        int n;
        char[] buffer = new char[4096];
        while ((n = input.read(buffer)) >= 0) {
            output.write(buffer, 0, n);
        }
    }

    public static class HttpResult {
        private final int code;
        private final String content;

        public HttpResult(int code, String content) {
            this.code = code;
            this.content = content;
        }

        public boolean isOk() {
            return 200 == this.code;
        }

        public int getCode() {
            return this.code;
        }

        public String getContent() {
            return this.content;
        }
    }
}

