/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.utility;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class UtilAll {
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final Locale LOCALE = new Locale("zh", "CN");
    private static final Random RANDOM = new SecureRandom();
    private static final int PROCESS_ID_NOT_SET = -2;
    private static final int PROCESS_ID_NOT_FOUND = -1;
    private static int PROCESS_ID = -2;
    private static final String HOST_NAME_NOT_FOUND = "HOST_NAME_NOT_FOUND";
    private static String HOST_NAME = null;
    private static byte[] MAC_ADDRESS = null;
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private UtilAll() {
    }

    public static byte[] macAddress() {
        if (null != MAC_ADDRESS) {
            return (byte[])MAC_ADDRESS.clone();
        }
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                byte[] mac = networkInterface.getHardwareAddress();
                if (null == mac) continue;
                MAC_ADDRESS = mac;
                return (byte[])MAC_ADDRESS.clone();
            }
        }
        catch (Throwable networkInterfaces) {
            // empty catch block
        }
        byte[] randomBytes = new byte[6];
        RANDOM.nextBytes(randomBytes);
        MAC_ADDRESS = randomBytes;
        return (byte[])MAC_ADDRESS.clone();
    }

    public static String getOsName() {
        try {
            return System.getProperty("os.name");
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String getOsVersion() {
        try {
            return System.getProperty("os.version");
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String getJavaHome() {
        try {
            return System.getProperty("java.home");
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static int processId() {
        if (PROCESS_ID != -2) {
            return PROCESS_ID;
        }
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        String name = runtime.getName();
        try {
            PROCESS_ID = Integer.parseInt(name.substring(0, name.indexOf(64)));
        }
        catch (Throwable ignore) {
            PROCESS_ID = -1;
        }
        return PROCESS_ID;
    }

    public static String hostName() {
        if (null != HOST_NAME) {
            return HOST_NAME;
        }
        try {
            HOST_NAME = InetAddress.getLocalHost().getHostName();
            return HOST_NAME;
        }
        catch (Throwable ignore) {
            HOST_NAME = HOST_NAME_NOT_FOUND;
            return HOST_NAME;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compressBytesGzip(byte[] src, int level) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(src.length);
        Deflater defeater = new Deflater(level);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, defeater);
        try {
            deflaterOutputStream.write(src);
            deflaterOutputStream.finish();
            deflaterOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
            defeater.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] uncompressBytesGzip(byte[] src) throws IOException {
        byte[] uncompressData = new byte[src.length];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(src);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(src.length);
        try {
            int length;
            while ((length = inflaterInputStream.read(uncompressData, 0, uncompressData.length)) > 0) {
                byteArrayOutputStream.write(uncompressData, 0, length);
            }
            byteArrayOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            try {
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                inflaterInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String encodeHexString(ByteBuffer byteBuffer, boolean toLowerCase) {
        return new String(UtilAll.encodeHex(byteBuffer, toLowerCase));
    }

    public static char[] encodeHex(ByteBuffer byteBuffer, boolean toLowerCase) {
        return UtilAll.encodeHex(byteBuffer, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    public static String encodeHexString(byte[] data, boolean toLowerCase) {
        return new String(UtilAll.encodeHex(data, toLowerCase));
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return UtilAll.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(ByteBuffer data, char[] toDigits) {
        return UtilAll.encodeHex(data.array(), toDigits);
    }

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    public static String crc32CheckSum(byte[] array) {
        CRC32 crc32 = new CRC32();
        crc32.update(array, 0, array.length);
        return Long.toHexString(crc32.getValue()).toUpperCase(LOCALE);
    }

    public static String md5CheckSum(byte[] array) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        digest.update(array);
        return UtilAll.encodeHexString(digest.digest(), false);
    }

    public static String sha1CheckSum(byte[] array) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        digest.update(array);
        return UtilAll.encodeHexString(digest.digest(), false);
    }

    public static String stackTrace() {
        return UtilAll.stackTrace(Thread.getAllStackTraces());
    }

    public static String stackTrace(Map<Thread, StackTraceElement[]> map) {
        StringBuilder result = new StringBuilder();
        try {
            for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
                StackTraceElement[] elements = entry.getValue();
                Thread thread = entry.getKey();
                if (elements == null || elements.length <= 0) continue;
                String threadName = entry.getKey().getName();
                result.append(String.format("%-40sTID: %d STATE: %s%n", new Object[]{threadName, thread.getId(), thread.getState()}));
                for (StackTraceElement el : elements) {
                    result.append(String.format("%-40s%s%n", threadName, el.toString()));
                }
                result.append("\n");
            }
        }
        catch (Throwable e) {
            result.append(e);
        }
        return result.toString();
    }
}

