/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.openservices.ots.ClientException;
import com.aliyun.openservices.ots.OTSException;
import com.aliyun.openservices.ots.PartialResultFailedException;
import com.aliyun.openservices.ots.internal.OTSRetryStrategy;

public class OTSDefaultRetryStrategy
implements OTSRetryStrategy {
    private static final int DEFAULT_RETRY_PAUSE_SCALE_IN_MILLIS = 50;
    private static final int DEFAULT_MAX_RETRY_PAUSE_IN_MILLIS = 100000;
    private static final int DEFAULT_MAX_RETRY_TIMES = 3;
    private int retryPauseInMillis = 50;
    private int maxPauseInMillis = 100000;
    private int maxRetryTimes = 3;

    public int getRetryPauseInMillis() {
        return this.retryPauseInMillis;
    }

    public void setRetryPauseInMillis(int retryPauseInMillis) {
        this.retryPauseInMillis = retryPauseInMillis;
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    public int getMaxPauseInMillis() {
        return this.maxPauseInMillis;
    }

    public void setMaxPauseInMillis(int maxPauseInMillis) {
        this.maxPauseInMillis = maxPauseInMillis;
    }

    private boolean isIdempotent(String action) {
        return action.equals("BatchGetRow") || action.equals("GetRange") || action.equals("DescribeTable") || action.equals("GetRow") || action.equals("ListTable");
    }

    private boolean retryNotMatterActions(String errorCode, String errorMessage) {
        return errorCode.equals("OTSRowOperationConflict") || errorCode.equals("OTSNotEnoughCapacityUnit") || errorCode.equals("OTSTableNotReady") || errorCode.equals("OTSPartitionUnavailable") || errorCode.equals("OTSServerBusy") || errorCode.equals("OTSQuotaExhausted") && errorMessage.equals("Too frequent table operations.");
    }

    public boolean shouldRetryWithOTSException(String action, boolean isIdempotent, String errorCode, String errorMessage, int httpStatus) {
        boolean serverError;
        if (this.retryNotMatterActions(errorCode, errorMessage)) {
            return true;
        }
        boolean bl = serverError = httpStatus >= 500 && httpStatus <= 599;
        return isIdempotent && (errorCode.equals("OTSTimeout") || errorCode.equals("OTSInternalServerError") || errorCode.equals("OTSServerUnavailable") || serverError);
    }

    @Override
    public boolean shouldRetry(String action, Exception ex, int retries) {
        if (retries > this.maxRetryTimes) {
            return false;
        }
        boolean isIdempotent = this.isIdempotent(action);
        if (ex instanceof OTSException) {
            if (ex instanceof PartialResultFailedException) {
                PartialResultFailedException prfe = (PartialResultFailedException)ex;
                for (OTSException otsException : prfe.getErrors()) {
                    if (this.shouldRetryWithOTSException(action, isIdempotent, otsException.getErrorCode(), otsException.getMessage(), prfe.getHttpStatus())) continue;
                    return false;
                }
                return true;
            }
            OTSException otsException = (OTSException)ex;
            return this.shouldRetryWithOTSException(action, isIdempotent, otsException.getErrorCode(), otsException.getMessage(), otsException.getHttpStatus());
        }
        if (ex instanceof ClientException) {
            return isIdempotent;
        }
        return false;
    }

    @Override
    public long getPauseDelay(String action, Exception ex, int retries) {
        int scale = this.retryPauseInMillis;
        if (retries > 30) {
            return this.maxPauseInMillis;
        }
        long delay = (long)Math.pow(2.0, retries) * (long)scale;
        return delay;
    }
}

