/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OTSTraceLogger {
    private String traceId;
    private List<Pair<String, Long>> eventTimeRecord;
    private List<Pair<String, String>> requestInfoRecord;
    private static Logger logger = LoggerFactory.getLogger(OTSTraceLogger.class);
    private int timeThreshold;

    public OTSTraceLogger(String traceId, int timeThreshold) {
        this.traceId = traceId;
        this.timeThreshold = timeThreshold;
        this.eventTimeRecord = new LinkedList<Pair<String, Long>>();
        this.requestInfoRecord = new LinkedList<Pair<String, String>>();
    }

    public void addRequestInfo(String key, String value) {
        this.requestInfoRecord.add(new Pair<String, String>(key, value));
    }

    public void addEventTime(String event, Long time) {
        this.eventTimeRecord.add(new Pair<String, Long>(event, time));
    }

    public void printLog() {
        if (logger.isWarnEnabled()) {
            long startTime = this.eventTimeRecord.get(0).getValue();
            long totalTime = this.eventTimeRecord.get(this.eventTimeRecord.size() - 1).getValue() - startTime;
            if (totalTime > (long)this.timeThreshold) {
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.append("TraceId:" + this.traceId + "\t");
                strBuilder.append("TotalTime:" + totalTime + "\t");
                for (Pair<String, String> pair : this.requestInfoRecord) {
                    strBuilder.append(pair + "\t");
                }
                for (Pair<String, Object> pair : this.eventTimeRecord) {
                    strBuilder.append(pair + "\t");
                }
                logger.warn(strBuilder.toString());
            }
        }
    }

    public String getTraceId() {
        return this.traceId;
    }

    private class Pair<K, V> {
        private K key;
        private V value;

        public Pair(K key, V value) {
            this.setKey(key);
            this.setValue(value);
        }

        public K getKey() {
            return this.key;
        }

        public void setKey(K key) {
            this.key = key;
        }

        public V getValue() {
            return this.value;
        }

        public void setValue(V value) {
            this.value = value;
        }

        public String toString() {
            return this.getKey() + ":" + this.getValue();
        }
    }
}

