/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.openservices.ots.model.BatchGetRowResult;
import com.aliyun.openservices.ots.model.MultiRowQueryCriteria;
import com.aliyun.openservices.ots.model.RowPrimaryKey;
import com.aliyun.openservices.ots.utils.CodingUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchGetRowRequest {
    private Map<String, MultiRowQueryCriteria> criteriasGroupByTable = new HashMap<String, MultiRowQueryCriteria>();

    public void addMultiRowQueryCriteria(MultiRowQueryCriteria criteria) {
        CodingUtils.assertParameterNotNull(criteria, "criteria");
        String tableName = criteria.getTableName();
        this.criteriasGroupByTable.put(tableName, criteria);
    }

    public RowPrimaryKey getPrimaryKey(String tableName, int index) {
        MultiRowQueryCriteria criteria = this.criteriasGroupByTable.get(tableName);
        if (criteria == null) {
            return null;
        }
        if (index >= criteria.getRowKeys().size()) {
            return null;
        }
        return criteria.getRowKeys().get(index);
    }

    public Map<String, MultiRowQueryCriteria> getCriteriasByTable() {
        return this.criteriasGroupByTable;
    }

    public MultiRowQueryCriteria getCriteria(String tableName) {
        return this.criteriasGroupByTable.get(tableName);
    }

    public BatchGetRowRequest createRequestForRetry(List<BatchGetRowResult.RowStatus> failedRows) {
        BatchGetRowRequest request = new BatchGetRowRequest();
        for (BatchGetRowResult.RowStatus rowResult : failedRows) {
            RowPrimaryKey primaryKey = this.getPrimaryKey(rowResult.getTableName(), rowResult.getIndex());
            if (primaryKey == null) {
                throw new IllegalArgumentException("Can not find table '" + rowResult.getTableName() + "' with index " + rowResult.getIndex());
            }
            MultiRowQueryCriteria newCriteria = request.getCriteria(rowResult.getTableName());
            if (newCriteria == null) {
                MultiRowQueryCriteria oldCriteria = this.getCriteria(rowResult.getTableName());
                if (oldCriteria == null) {
                    throw new IllegalArgumentException("Can not found query criteria for table '" + rowResult.getTableName() + "'.");
                }
                newCriteria = oldCriteria.cloneWithoutRowKeys();
                newCriteria.addRow(primaryKey);
                request.addMultiRowQueryCriteria(newCriteria);
                continue;
            }
            newCriteria.addRow(primaryKey);
        }
        return request;
    }

    public boolean isEmpty() {
        return this.criteriasGroupByTable.isEmpty();
    }
}

