/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.auth;

import com.alicloud.openservices.tablestore.core.auth.HmacSHA1Signature;
import com.alicloud.openservices.tablestore.core.auth.ServiceCredentials;
import com.alicloud.openservices.tablestore.core.auth.SignatureMakerInterface;
import com.alicloud.openservices.tablestore.core.http.RequestMessage;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.Header;

public class V2SignatureMaker
implements SignatureMakerInterface {
    private final ServiceCredentials credentials;

    public V2SignatureMaker(ServiceCredentials credentials) {
        this.credentials = credentials;
    }

    @Override
    public String getSignature(byte[] accessKey, String action, String method, Header[] headers) throws UnsupportedEncodingException {
        StringBuilder canonicalizedOtsHeader = new StringBuilder(1000);
        TreeMap<String, String> headerMap = new TreeMap<String, String>();
        for (Header header : headers) {
            headerMap.put(header.getName(), header.getValue());
        }
        for (Map.Entry entry : headerMap.entrySet()) {
            String key = (String)entry.getKey();
            String val = ((String)entry.getValue()).trim();
            if (!key.startsWith("x-ots-")) continue;
            canonicalizedOtsHeader.append(key).append(":").append(val).append("\n");
        }
        StringBuilder sb = new StringBuilder(1000);
        sb.append("/").append(action).append("\n").append(method).append("\n").append("\n").append(canonicalizedOtsHeader.toString());
        HmacSHA1Signature hmacSHA1Signature = new HmacSHA1Signature(accessKey);
        hmacSHA1Signature.updateUTF8String(sb.toString());
        return hmacSHA1Signature.computeSignature();
    }

    @Override
    public String getSignatureHeader() {
        return "x-ots-signature";
    }

    @Override
    public void addExtraHeader(RequestMessage request) {
        request.addHeader("x-ots-accesskeyid", this.credentials.getAccessKeyId());
        if (this.credentials.getSecurityToken() != null && !this.credentials.getSecurityToken().isEmpty()) {
            request.addHeader("x-ots-ststoken", this.credentials.getSecurityToken());
        }
    }
}

