/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.parser.ResponseParseException;
import com.aliyun.oss.common.parser.ResponseParser;
import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.common.utils.DateUtil;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.model.AccessControlList;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.BucketList;
import com.aliyun.oss.model.BucketLoggingResult;
import com.aliyun.oss.model.BucketReferer;
import com.aliyun.oss.model.BucketWebsiteResult;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.CopyObjectResult;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.GroupGrantee;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.LifecycleRule;
import com.aliyun.oss.model.MultipartUpload;
import com.aliyun.oss.model.MultipartUploadListing;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.Owner;
import com.aliyun.oss.model.PartListing;
import com.aliyun.oss.model.PartSummary;
import com.aliyun.oss.model.Permission;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.SetBucketCORSRequest;
import com.aliyun.oss.model.UploadPartCopyResult;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public final class ResponseParsers {
    public static final ListBucketResponseParser listBucketResponseParser = new ListBucketResponseParser();
    public static final GetBucketRefererResponseParser getBucketRefererResponseParser = new GetBucketRefererResponseParser();
    public static final GetBucketAclResponseParser getBucketAclResponseParser = new GetBucketAclResponseParser();
    public static final GetBucketLocationResponseParser getBucketLocationResponseParser = new GetBucketLocationResponseParser();
    public static final GetBucketLoggingResponseParser getBucketLoggingResponseParser = new GetBucketLoggingResponseParser();
    public static final GetBucketWebsiteResponseParser getBucketWebsiteResponseParser = new GetBucketWebsiteResponseParser();
    public static final GetBucketLifecycleResponseParser getBucketLifecycleResponseParser = new GetBucketLifecycleResponseParser();
    public static final GetBucketCorsResponseParser getBucketCorsResponseParser = new GetBucketCorsResponseParser();
    public static final ListObjectsReponseParser listObjectsReponseParser = new ListObjectsReponseParser();
    public static final PutObjectReponseParser putObjectReponseParser = new PutObjectReponseParser();
    public static final GetObjectMetadataResponseParser getObjectMetadataResponseParser = new GetObjectMetadataResponseParser();
    public static final CopyObjectResponseParser copyObjectResponseParser = new CopyObjectResponseParser();
    public static final DeleteObjectsResponseParser deleteObjectsResponseParser = new DeleteObjectsResponseParser();
    public static final CompleteMultipartUploadResponseParser completeMultipartUploadResponseParser = new CompleteMultipartUploadResponseParser();
    public static final InitiateMultipartUploadResponseParser initiateMultipartUploadResponseParser = new InitiateMultipartUploadResponseParser();
    public static final ListMultipartUploadsResponseParser listMultipartUploadsResponseParser = new ListMultipartUploadsResponseParser();
    public static final ListPartsResponseParser listPartsResponseParser = new ListPartsResponseParser();

    private static Element getXmlRootElement(InputStream responseBody) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(responseBody);
        return doc.getRootElement();
    }

    public static ObjectListing parseListObjects(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ObjectListing objectListing = new ObjectListing();
            objectListing.setBucketName(root.getChildText("Name"));
            objectListing.setMaxKeys(Integer.valueOf(root.getChildText("MaxKeys")));
            objectListing.setTruncated(Boolean.valueOf(root.getChildText("IsTruncated")));
            if (root.getChild("Prefix") != null) {
                String prefix = root.getChildText("Prefix");
                objectListing.setPrefix(CodingUtils.isNullOrEmpty(prefix) ? null : prefix);
            }
            if (root.getChild("Marker") != null) {
                String marker = root.getChildText("Marker");
                objectListing.setMarker(CodingUtils.isNullOrEmpty(marker) ? null : marker);
            }
            if (root.getChild("Delimiter") != null) {
                String delimiter = root.getChildText("Delimiter");
                objectListing.setDelimiter(CodingUtils.isNullOrEmpty(delimiter) ? null : delimiter);
            }
            if (root.getChild("NextMarker") != null) {
                String nextMarker = root.getChildText("NextMarker");
                objectListing.setNextMarker(CodingUtils.isNullOrEmpty(nextMarker) ? null : nextMarker);
            }
            List objectSummaryElems = root.getChildren("Contents");
            for (Element elem : objectSummaryElems) {
                OSSObjectSummary ossObjectSummary = new OSSObjectSummary();
                ossObjectSummary.setKey(elem.getChildText("Key"));
                ossObjectSummary.setETag(OSSUtils.trimQuotes(elem.getChildText("ETag")));
                ossObjectSummary.setLastModified(DateUtil.parseIso8601Date(elem.getChildText("LastModified")));
                ossObjectSummary.setSize(Long.valueOf(elem.getChildText("Size")));
                ossObjectSummary.setStorageClass(elem.getChildText("StorageClass"));
                ossObjectSummary.setBucketName(objectListing.getBucketName());
                String id = elem.getChild("Owner").getChildText("ID");
                String displayName = elem.getChild("Owner").getChildText("DisplayName");
                ossObjectSummary.setOwner(new Owner(id, displayName));
                objectListing.addObjectSummary(ossObjectSummary);
            }
            List commonPrefixesElems = root.getChildren("CommonPrefixes");
            for (Element elem : commonPrefixesElems) {
                String prefix = elem.getChildText("Prefix");
                if (CodingUtils.isNullOrEmpty(prefix)) continue;
                objectListing.addCommonPrefix(prefix);
            }
            return objectListing;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static AccessControlList parseGetBucketAcl(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            AccessControlList acl = new AccessControlList();
            String id = root.getChild("Owner").getChildText("ID");
            String displayName = root.getChild("Owner").getChildText("DisplayName");
            Owner owner = new Owner(id, displayName);
            acl.setOwner(owner);
            String aclString = root.getChild("AccessControlList").getChildText("Grant");
            CannedAccessControlList cacl = CannedAccessControlList.parse(aclString);
            if (cacl == CannedAccessControlList.PublicRead) {
                acl.grantPermission(GroupGrantee.AllUsers, Permission.Read);
            } else if (cacl == CannedAccessControlList.PublicReadWrite) {
                acl.grantPermission(GroupGrantee.AllUsers, Permission.FullControl);
            }
            return acl;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketReferer parseGetBucketReferer(InputStream responseBody) throws ResponseParseException {
        try {
            Element refererListElem;
            List refererElems;
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            boolean allowEmptyReferer = Boolean.valueOf(root.getChildText("AllowEmptyReferer"));
            ArrayList<String> refererList = new ArrayList<String>();
            if (root.getChild("RefererList") != null && (refererElems = (refererListElem = root.getChild("RefererList")).getChildren("Referer")) != null && !refererElems.isEmpty()) {
                for (Element e : refererElems) {
                    refererList.add(e.getText());
                }
            }
            return new BucketReferer(allowEmptyReferer, refererList);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static String parseUploadPartCopy(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            return root.getChildText("ETag");
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketList parseListBucket(InputStream responseBody) throws ResponseParseException {
        try {
            String value;
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            BucketList bucketList = new BucketList();
            if (root.getChild("Prefix") != null) {
                bucketList.setPrefix(root.getChildText("Prefix"));
            }
            if (root.getChild("Marker") != null) {
                bucketList.setMarker(root.getChildText("Marker"));
            }
            if (root.getChild("MaxKeys") != null) {
                value = root.getChildText("MaxKeys");
                bucketList.setMaxKeys(CodingUtils.isNullOrEmpty(value) ? null : Integer.valueOf(value));
            }
            if (root.getChild("IsTruncated") != null) {
                value = root.getChildText("IsTruncated");
                bucketList.setTruncated(CodingUtils.isNullOrEmpty(value) ? false : Boolean.valueOf(value));
            }
            if (root.getChild("NextMarker") != null) {
                bucketList.setNextMarker(root.getChildText("NextMarker"));
            }
            Element ownerElem = root.getChild("Owner");
            String id = ownerElem.getChildText("ID");
            String displayName = ownerElem.getChildText("DisplayName");
            Owner owner = new Owner(id, displayName);
            ArrayList<Bucket> buckets = new ArrayList<Bucket>();
            if (root.getChild("Buckets") != null) {
                List bucketElems = root.getChild("Buckets").getChildren("Bucket");
                for (Element e : bucketElems) {
                    Bucket bucket = new Bucket();
                    bucket.setOwner(owner);
                    bucket.setName(e.getChildText("Name"));
                    bucket.setLocation(e.getChildText("Location"));
                    bucket.setCreationDate(DateUtil.parseIso8601Date(e.getChildText("CreationDate")));
                    buckets.add(bucket);
                }
            }
            bucketList.setBucketList(buckets);
            return bucketList;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static String parseGetBucketLocation(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            return root.getText();
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static ObjectMetadata parseObjectMetadata(Map<String, String> headers) throws ResponseParseException {
        try {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            for (String key : headers.keySet()) {
                if (key.indexOf("x-oss-meta-") >= 0) {
                    key = key.substring("x-oss-meta-".length());
                    objectMetadata.addUserMetadata(key, headers.get("x-oss-meta-" + key));
                    continue;
                }
                if (key.equals("Last-Modified") || key.equals("Date") || key.equals("Expires")) {
                    try {
                        objectMetadata.setHeader(key, DateUtil.parseRfc822Date(headers.get(key)));
                        continue;
                    }
                    catch (ParseException pe) {
                        throw new ResponseParseException(pe.getMessage(), pe);
                    }
                }
                if (key.equals("Content-Length")) {
                    Long value = Long.valueOf(headers.get(key));
                    objectMetadata.setHeader(key, value);
                    continue;
                }
                if (key.equals("ETag")) {
                    objectMetadata.setHeader(key, OSSUtils.trimQuotes(headers.get(key)));
                    continue;
                }
                objectMetadata.setHeader(key, headers.get(key));
            }
            return objectMetadata;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static InitiateMultipartUploadResult parseInitiateMultipartUpload(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            InitiateMultipartUploadResult result = new InitiateMultipartUploadResult();
            if (root.getChild("Bucket") != null) {
                result.setBucketName(root.getChildText("Bucket"));
            }
            if (root.getChild("Key") != null) {
                result.setKey(root.getChildText("Key"));
            }
            if (root.getChild("UploadId") != null) {
                result.setUploadId(root.getChildText("UploadId"));
            }
            return result;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static MultipartUploadListing parseListMultipartUploads(InputStream responseBody) throws ResponseParseException {
        try {
            String nextUploadIdMarker;
            String nextKeyMarker;
            String uploadIdMarker;
            String keyMarker;
            String prefix;
            String delimiter;
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            MultipartUploadListing multipartUploadListing = new MultipartUploadListing();
            multipartUploadListing.setBucketName(root.getChildText("Bucket"));
            multipartUploadListing.setMaxUploads(Integer.valueOf(root.getChildText("MaxUploads")));
            multipartUploadListing.setTruncated(Boolean.valueOf(root.getChildText("IsTruncated")));
            if (root.getChild("Delimiter") != null && !CodingUtils.isNullOrEmpty(delimiter = root.getChildText("Delimiter"))) {
                multipartUploadListing.setDelimiter(delimiter);
            }
            if (root.getChild("Prefix") != null && !CodingUtils.isNullOrEmpty(prefix = root.getChildText("Prefix"))) {
                multipartUploadListing.setPrefix(prefix);
            }
            if (root.getChild("KeyMarker") != null && !CodingUtils.isNullOrEmpty(keyMarker = root.getChildText("KeyMarker"))) {
                multipartUploadListing.setKeyMarker(keyMarker);
            }
            if (root.getChild("UploadIdMarker") != null && !CodingUtils.isNullOrEmpty(uploadIdMarker = root.getChildText("UploadIdMarker"))) {
                multipartUploadListing.setUploadIdMarker(uploadIdMarker);
            }
            if (root.getChild("NextKeyMarker") != null && !CodingUtils.isNullOrEmpty(nextKeyMarker = root.getChildText("NextKeyMarker"))) {
                multipartUploadListing.setNextKeyMarker(nextKeyMarker);
            }
            if (root.getChild("NextUploadIdMarker") != null && !CodingUtils.isNullOrEmpty(nextUploadIdMarker = root.getChildText("NextUploadIdMarker"))) {
                multipartUploadListing.setNextUploadIdMarker(nextUploadIdMarker);
            }
            List uploadElems = root.getChildren("Upload");
            for (Element elem : uploadElems) {
                if (elem.getChild("Initiated") == null) continue;
                MultipartUpload mu = new MultipartUpload();
                mu.setKey(elem.getChildText("Key"));
                mu.setUploadId(elem.getChildText("UploadId"));
                mu.setStorageClass(elem.getChildText("StorageClass"));
                mu.setInitiated(DateUtil.parseIso8601Date(elem.getChildText("Initiated")));
                multipartUploadListing.addMultipartUpload(mu);
            }
            List commonPrefixesElems = root.getChildren("CommonPrefixes");
            for (Element elem : commonPrefixesElems) {
                String prefix2 = elem.getChildText("Prefix");
                if (CodingUtils.isNullOrEmpty(prefix2)) continue;
                multipartUploadListing.addCommonPrefix(prefix2);
            }
            return multipartUploadListing;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static PartListing parseListParts(InputStream responseBody) throws ResponseParseException {
        try {
            String nextPartNumberMarker;
            String partNumberMarker;
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            PartListing partListing = new PartListing();
            partListing.setBucketName(root.getChildText("Bucket"));
            partListing.setKey(root.getChildText("Key"));
            partListing.setUploadId(root.getChildText("UploadId"));
            partListing.setStorageClass(root.getChildText("StorageClass"));
            partListing.setMaxParts(Integer.valueOf(root.getChildText("MaxParts")));
            partListing.setTruncated(Boolean.valueOf(root.getChildText("IsTruncated")));
            if (root.getChild("PartNumberMarker") != null && !CodingUtils.isNullOrEmpty(partNumberMarker = root.getChildText("PartNumberMarker"))) {
                partListing.setPartNumberMarker(Integer.valueOf(partNumberMarker));
            }
            if (root.getChild("NextPartNumberMarker") != null && !CodingUtils.isNullOrEmpty(nextPartNumberMarker = root.getChildText("NextPartNumberMarker"))) {
                partListing.setNextPartNumberMarker(Integer.valueOf(nextPartNumberMarker));
            }
            List partElems = root.getChildren("Part");
            for (Element elem : partElems) {
                PartSummary ps = new PartSummary();
                ps.setPartNumber(Integer.valueOf(elem.getChildText("PartNumber")));
                ps.setLastModified(DateUtil.parseIso8601Date(elem.getChildText("LastModified")));
                ps.setETag(OSSUtils.trimQuotes(elem.getChildText("ETag")));
                ps.setSize(Integer.valueOf(elem.getChildText("Size")).intValue());
                partListing.addPart(ps);
            }
            return partListing;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static CompleteMultipartUploadResult parseCompleteMultipartUpload(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            CompleteMultipartUploadResult result = new CompleteMultipartUploadResult();
            result.setBucketName(root.getChildText("Bucket"));
            result.setETag(OSSUtils.trimQuotes(root.getChildText("ETag")));
            result.setKey(root.getChildText("Key"));
            result.setLocation(root.getChildText("Location"));
            return result;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketLoggingResult parseBucketLogging(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            BucketLoggingResult result = new BucketLoggingResult();
            if (root.getChild("LoggingEnabled") != null) {
                result.setTargetBucket(root.getChild("LoggingEnabled").getChildText("TargetBucket"));
            }
            if (root.getChild("LoggingEnabled") != null) {
                result.setTargetPrefix(root.getChild("LoggingEnabled").getChildText("TargetPrefix"));
            }
            return result;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketWebsiteResult parseBucketWebsite(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            BucketWebsiteResult result = new BucketWebsiteResult();
            if (root.getChild("IndexDocument") != null) {
                result.setIndexDocument(root.getChild("IndexDocument").getChildText("Suffix"));
            }
            if (root.getChild("ErrorDocument") != null) {
                result.setErrorDocument(root.getChild("ErrorDocument").getChildText("Key"));
            }
            return result;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static CopyObjectResult parseCopyObjectResult(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            CopyObjectResult result = new CopyObjectResult();
            result.setLastModified(DateUtil.parseIso8601Date(root.getChildText("LastModified")));
            result.setEtag(OSSUtils.trimQuotes(root.getChildText("ETag")));
            return result;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static DeleteObjectsResult parseDeleteObjectsResult(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ArrayList<String> deletedObjects = new ArrayList<String>();
            List deletedElements = root.getChildren("Deleted");
            for (Element elem : deletedElements) {
                deletedObjects.add(elem.getChildText("Key"));
            }
            return new DeleteObjectsResult(deletedObjects);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static List<SetBucketCORSRequest.CORSRule> parseListBucketCORS(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ArrayList<SetBucketCORSRequest.CORSRule> corsRules = new ArrayList<SetBucketCORSRequest.CORSRule>();
            List corsRuleElems = root.getChildren("CORSRule");
            for (Element corsRuleElem : corsRuleElems) {
                SetBucketCORSRequest.CORSRule rule = new SetBucketCORSRequest.CORSRule();
                List allowedOriginElems = corsRuleElem.getChildren("AllowedOrigin");
                for (Element allowedOriginElement : allowedOriginElems) {
                    rule.getAllowedOrigins().add(allowedOriginElement.getValue());
                }
                List allowedMethodElems = corsRuleElem.getChildren("AllowedMethod");
                for (Element allowedMethodElement : allowedMethodElems) {
                    rule.getAllowedMethods().add(allowedMethodElement.getValue());
                }
                List allowedHeaderElems = corsRuleElem.getChildren("AllowedHeader");
                for (Element allowedHeaderElement : allowedHeaderElems) {
                    rule.getAllowedHeaders().add(allowedHeaderElement.getValue());
                }
                List exposeHeaderElems = corsRuleElem.getChildren("ExposeHeader");
                for (Element exposeHeaderElement : exposeHeaderElems) {
                    rule.getExposeHeaders().add(exposeHeaderElement.getValue());
                }
                Element maxAgeSecondsElem = corsRuleElem.getChild("MaxAgeSeconds");
                if (maxAgeSecondsElem != null) {
                    rule.setMaxAgeSeconds(Integer.parseInt(maxAgeSecondsElem.getValue()));
                }
                corsRules.add(rule);
            }
            return corsRules;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static List<LifecycleRule> parseGetBucketLifecycle(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ArrayList<LifecycleRule> lifecycleRules = new ArrayList<LifecycleRule>();
            List ruleElements = root.getChildren("Rule");
            for (Element ruleElem : ruleElements) {
                LifecycleRule rule = new LifecycleRule();
                if (ruleElem.getChild("ID") != null) {
                    rule.setId(ruleElem.getChildText("ID"));
                }
                if (ruleElem.getChild("Prefix") != null) {
                    rule.setPrefix(ruleElem.getChildText("Prefix"));
                }
                if (ruleElem.getChild("Status") != null) {
                    rule.setStatus(LifecycleRule.RuleStatus.valueOf(ruleElem.getChildText("Status")));
                }
                if (ruleElem.getChild("Expiration") != null) {
                    if (ruleElem.getChild("Expiration").getChild("Date") != null) {
                        Date expirationDate = DateUtil.parseIso8601Date(ruleElem.getChild("Expiration").getChildText("Date"));
                        rule.setExpirationTime(expirationDate);
                    } else {
                        rule.setExpriationDays(Integer.parseInt(ruleElem.getChild("Expiration").getChildText("Days")));
                    }
                }
                lifecycleRules.add(rule);
            }
            return lifecycleRules;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static final class UploadPartCopyResponseParser
    implements ResponseParser<UploadPartCopyResult> {
        private int partNumber;

        public UploadPartCopyResponseParser(int partNumber) {
            this.partNumber = partNumber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UploadPartCopyResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                UploadPartCopyResult result = new UploadPartCopyResult();
                result.setPartNumber(this.partNumber);
                result.setETag(OSSUtils.trimQuotes(ResponseParsers.parseUploadPartCopy(response.getContent())));
                UploadPartCopyResult uploadPartCopyResult = result;
                return uploadPartCopyResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListPartsResponseParser
    implements ResponseParser<PartListing> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PartListing parse(ResponseMessage response) throws ResponseParseException {
            try {
                PartListing partListing = ResponseParsers.parseListParts(response.getContent());
                return partListing;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListMultipartUploadsResponseParser
    implements ResponseParser<MultipartUploadListing> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MultipartUploadListing parse(ResponseMessage response) throws ResponseParseException {
            try {
                MultipartUploadListing multipartUploadListing = ResponseParsers.parseListMultipartUploads(response.getContent());
                return multipartUploadListing;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class InitiateMultipartUploadResponseParser
    implements ResponseParser<InitiateMultipartUploadResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InitiateMultipartUploadResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                InitiateMultipartUploadResult initiateMultipartUploadResult = ResponseParsers.parseInitiateMultipartUpload(response.getContent());
                return initiateMultipartUploadResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class CompleteMultipartUploadResponseParser
    implements ResponseParser<CompleteMultipartUploadResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompleteMultipartUploadResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                CompleteMultipartUploadResult completeMultipartUploadResult = ResponseParsers.parseCompleteMultipartUpload(response.getContent());
                return completeMultipartUploadResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class DeleteObjectsResponseParser
    implements ResponseParser<DeleteObjectsResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DeleteObjectsResult parse(ResponseMessage response) throws ResponseParseException {
            if (response.getContentLength() == 0L) {
                return new DeleteObjectsResult(null);
            }
            try {
                DeleteObjectsResult deleteObjectsResult = ResponseParsers.parseDeleteObjectsResult(response.getContent());
                return deleteObjectsResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class CopyObjectResponseParser
    implements ResponseParser<CopyObjectResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CopyObjectResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                CopyObjectResult copyObjectResult = ResponseParsers.parseCopyObjectResult(response.getContent());
                return copyObjectResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetObjectMetadataResponseParser
    implements ResponseParser<ObjectMetadata> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectMetadata parse(ResponseMessage response) throws ResponseParseException {
            try {
                ObjectMetadata objectMetadata = ResponseParsers.parseObjectMetadata(response.getHeaders());
                return objectMetadata;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetObjectResponseParser
    implements ResponseParser<OSSObject> {
        private String bucketName;
        private String key;

        public GetObjectResponseParser(String bucketName, String key) {
            this.bucketName = bucketName;
            this.key = key;
        }

        @Override
        public OSSObject parse(ResponseMessage response) throws ResponseParseException {
            OSSObject ossObject = new OSSObject();
            ossObject.setBucketName(this.bucketName);
            ossObject.setKey(this.key);
            ossObject.setObjectContent(response.getContent());
            try {
                ossObject.setObjectMetadata(ResponseParsers.parseObjectMetadata(response.getHeaders()));
                return ossObject;
            }
            catch (ResponseParseException e) {
                OSSUtils.safeCloseResponse(response);
                throw e;
            }
        }
    }

    public static final class PutObjectReponseParser
    implements ResponseParser<PutObjectResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PutObjectResult parse(ResponseMessage response) throws ResponseParseException {
            PutObjectResult result = new PutObjectResult();
            try {
                result.setETag(OSSUtils.trimQuotes(response.getHeaders().get("ETag")));
                PutObjectResult putObjectResult = result;
                return putObjectResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListObjectsReponseParser
    implements ResponseParser<ObjectListing> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectListing parse(ResponseMessage response) throws ResponseParseException {
            try {
                ObjectListing objectListing = ResponseParsers.parseListObjects(response.getContent());
                return objectListing;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketCorsResponseParser
    implements ResponseParser<List<SetBucketCORSRequest.CORSRule>> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<SetBucketCORSRequest.CORSRule> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<SetBucketCORSRequest.CORSRule> list = ResponseParsers.parseListBucketCORS(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketLifecycleResponseParser
    implements ResponseParser<List<LifecycleRule>> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<LifecycleRule> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<LifecycleRule> list = ResponseParsers.parseGetBucketLifecycle(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketWebsiteResponseParser
    implements ResponseParser<BucketWebsiteResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketWebsiteResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketWebsiteResult bucketWebsiteResult = ResponseParsers.parseBucketWebsite(response.getContent());
                return bucketWebsiteResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketLoggingResponseParser
    implements ResponseParser<BucketLoggingResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketLoggingResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketLoggingResult bucketLoggingResult = ResponseParsers.parseBucketLogging(response.getContent());
                return bucketLoggingResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketLocationResponseParser
    implements ResponseParser<String> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String parse(ResponseMessage response) throws ResponseParseException {
            try {
                String string = ResponseParsers.parseGetBucketLocation(response.getContent());
                return string;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketAclResponseParser
    implements ResponseParser<AccessControlList> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AccessControlList parse(ResponseMessage response) throws ResponseParseException {
            try {
                AccessControlList accessControlList = ResponseParsers.parseGetBucketAcl(response.getContent());
                return accessControlList;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketRefererResponseParser
    implements ResponseParser<BucketReferer> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketReferer parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketReferer bucketReferer = ResponseParsers.parseGetBucketReferer(response.getContent());
                return bucketReferer;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListBucketResponseParser
    implements ResponseParser<BucketList> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketList parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketList bucketList = ResponseParsers.parseListBucket(response.getContent());
                return bucketList;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class EmptyResponseParser
    implements ResponseParser<ResponseMessage> {
        @Override
        public ResponseMessage parse(ResponseMessage response) throws ResponseParseException {
            OSSUtils.safeCloseResponse(response);
            return response;
        }
    }
}

