/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevidently.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudwatchevidently.model.ExperimentResultResponseType;
import com.amazonaws.services.cloudwatchevidently.model.transform.ExperimentResultsDataMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExperimentResultsData
implements Serializable,
Cloneable,
StructuredPojo {
    private String metricName;
    private String resultStat;
    private String treatmentName;
    private List<Double> values;

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public ExperimentResultsData withMetricName(String metricName) {
        this.setMetricName(metricName);
        return this;
    }

    public void setResultStat(String resultStat) {
        this.resultStat = resultStat;
    }

    public String getResultStat() {
        return this.resultStat;
    }

    public ExperimentResultsData withResultStat(String resultStat) {
        this.setResultStat(resultStat);
        return this;
    }

    public ExperimentResultsData withResultStat(ExperimentResultResponseType resultStat) {
        this.resultStat = resultStat.toString();
        return this;
    }

    public void setTreatmentName(String treatmentName) {
        this.treatmentName = treatmentName;
    }

    public String getTreatmentName() {
        return this.treatmentName;
    }

    public ExperimentResultsData withTreatmentName(String treatmentName) {
        this.setTreatmentName(treatmentName);
        return this;
    }

    public List<Double> getValues() {
        return this.values;
    }

    public void setValues(Collection<Double> values) {
        if (values == null) {
            this.values = null;
            return;
        }
        this.values = new ArrayList<Double>(values);
    }

    public ExperimentResultsData withValues(Double ... values) {
        if (this.values == null) {
            this.setValues(new ArrayList<Double>(values.length));
        }
        for (Double ele : values) {
            this.values.add(ele);
        }
        return this;
    }

    public ExperimentResultsData withValues(Collection<Double> values) {
        this.setValues(values);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMetricName() != null) {
            sb.append("MetricName: ").append(this.getMetricName()).append(",");
        }
        if (this.getResultStat() != null) {
            sb.append("ResultStat: ").append(this.getResultStat()).append(",");
        }
        if (this.getTreatmentName() != null) {
            sb.append("TreatmentName: ").append(this.getTreatmentName()).append(",");
        }
        if (this.getValues() != null) {
            sb.append("Values: ").append(this.getValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentResultsData)) {
            return false;
        }
        ExperimentResultsData other = (ExperimentResultsData)obj;
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        if (other.getMetricName() != null && !other.getMetricName().equals(this.getMetricName())) {
            return false;
        }
        if (other.getResultStat() == null ^ this.getResultStat() == null) {
            return false;
        }
        if (other.getResultStat() != null && !other.getResultStat().equals(this.getResultStat())) {
            return false;
        }
        if (other.getTreatmentName() == null ^ this.getTreatmentName() == null) {
            return false;
        }
        if (other.getTreatmentName() != null && !other.getTreatmentName().equals(this.getTreatmentName())) {
            return false;
        }
        if (other.getValues() == null ^ this.getValues() == null) {
            return false;
        }
        return other.getValues() == null || other.getValues().equals(this.getValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        hashCode = 31 * hashCode + (this.getResultStat() == null ? 0 : this.getResultStat().hashCode());
        hashCode = 31 * hashCode + (this.getTreatmentName() == null ? 0 : this.getTreatmentName().hashCode());
        hashCode = 31 * hashCode + (this.getValues() == null ? 0 : this.getValues().hashCode());
        return hashCode;
    }

    public ExperimentResultsData clone() {
        try {
            return (ExperimentResultsData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExperimentResultsDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

