/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevidently.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudwatchevidently.model.transform.OnlineAbConfigMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class OnlineAbConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String controlTreatmentName;
    private Map<String, Long> treatmentWeights;

    public void setControlTreatmentName(String controlTreatmentName) {
        this.controlTreatmentName = controlTreatmentName;
    }

    public String getControlTreatmentName() {
        return this.controlTreatmentName;
    }

    public OnlineAbConfig withControlTreatmentName(String controlTreatmentName) {
        this.setControlTreatmentName(controlTreatmentName);
        return this;
    }

    public Map<String, Long> getTreatmentWeights() {
        return this.treatmentWeights;
    }

    public void setTreatmentWeights(Map<String, Long> treatmentWeights) {
        this.treatmentWeights = treatmentWeights;
    }

    public OnlineAbConfig withTreatmentWeights(Map<String, Long> treatmentWeights) {
        this.setTreatmentWeights(treatmentWeights);
        return this;
    }

    public OnlineAbConfig addTreatmentWeightsEntry(String key, Long value) {
        if (null == this.treatmentWeights) {
            this.treatmentWeights = new HashMap<String, Long>();
        }
        if (this.treatmentWeights.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.treatmentWeights.put(key, value);
        return this;
    }

    public OnlineAbConfig clearTreatmentWeightsEntries() {
        this.treatmentWeights = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getControlTreatmentName() != null) {
            sb.append("ControlTreatmentName: ").append(this.getControlTreatmentName()).append(",");
        }
        if (this.getTreatmentWeights() != null) {
            sb.append("TreatmentWeights: ").append(this.getTreatmentWeights());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnlineAbConfig)) {
            return false;
        }
        OnlineAbConfig other = (OnlineAbConfig)obj;
        if (other.getControlTreatmentName() == null ^ this.getControlTreatmentName() == null) {
            return false;
        }
        if (other.getControlTreatmentName() != null && !other.getControlTreatmentName().equals(this.getControlTreatmentName())) {
            return false;
        }
        if (other.getTreatmentWeights() == null ^ this.getTreatmentWeights() == null) {
            return false;
        }
        return other.getTreatmentWeights() == null || other.getTreatmentWeights().equals(this.getTreatmentWeights());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getControlTreatmentName() == null ? 0 : this.getControlTreatmentName().hashCode());
        hashCode = 31 * hashCode + (this.getTreatmentWeights() == null ? 0 : this.getTreatmentWeights().hashCode());
        return hashCode;
    }

    public OnlineAbConfig clone() {
        try {
            return (OnlineAbConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OnlineAbConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

