/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cognitoidp.model.HttpHeader;
import com.amazonaws.services.cognitoidp.model.transform.ContextDataTypeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ContextDataType
implements Serializable,
Cloneable,
StructuredPojo {
    private String ipAddress;
    private String serverName;
    private String serverPath;
    private List<HttpHeader> httpHeaders;
    private String encodedData;

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public ContextDataType withIpAddress(String ipAddress) {
        this.setIpAddress(ipAddress);
        return this;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public ContextDataType withServerName(String serverName) {
        this.setServerName(serverName);
        return this;
    }

    public void setServerPath(String serverPath) {
        this.serverPath = serverPath;
    }

    public String getServerPath() {
        return this.serverPath;
    }

    public ContextDataType withServerPath(String serverPath) {
        this.setServerPath(serverPath);
        return this;
    }

    public List<HttpHeader> getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(Collection<HttpHeader> httpHeaders) {
        if (httpHeaders == null) {
            this.httpHeaders = null;
            return;
        }
        this.httpHeaders = new ArrayList<HttpHeader>(httpHeaders);
    }

    public ContextDataType withHttpHeaders(HttpHeader ... httpHeaders) {
        if (this.httpHeaders == null) {
            this.setHttpHeaders(new ArrayList<HttpHeader>(httpHeaders.length));
        }
        for (HttpHeader ele : httpHeaders) {
            this.httpHeaders.add(ele);
        }
        return this;
    }

    public ContextDataType withHttpHeaders(Collection<HttpHeader> httpHeaders) {
        this.setHttpHeaders(httpHeaders);
        return this;
    }

    public void setEncodedData(String encodedData) {
        this.encodedData = encodedData;
    }

    public String getEncodedData() {
        return this.encodedData;
    }

    public ContextDataType withEncodedData(String encodedData) {
        this.setEncodedData(encodedData);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIpAddress() != null) {
            sb.append("IpAddress: ").append(this.getIpAddress()).append(",");
        }
        if (this.getServerName() != null) {
            sb.append("ServerName: ").append(this.getServerName()).append(",");
        }
        if (this.getServerPath() != null) {
            sb.append("ServerPath: ").append(this.getServerPath()).append(",");
        }
        if (this.getHttpHeaders() != null) {
            sb.append("HttpHeaders: ").append(this.getHttpHeaders()).append(",");
        }
        if (this.getEncodedData() != null) {
            sb.append("EncodedData: ").append(this.getEncodedData());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContextDataType)) {
            return false;
        }
        ContextDataType other = (ContextDataType)obj;
        if (other.getIpAddress() == null ^ this.getIpAddress() == null) {
            return false;
        }
        if (other.getIpAddress() != null && !other.getIpAddress().equals(this.getIpAddress())) {
            return false;
        }
        if (other.getServerName() == null ^ this.getServerName() == null) {
            return false;
        }
        if (other.getServerName() != null && !other.getServerName().equals(this.getServerName())) {
            return false;
        }
        if (other.getServerPath() == null ^ this.getServerPath() == null) {
            return false;
        }
        if (other.getServerPath() != null && !other.getServerPath().equals(this.getServerPath())) {
            return false;
        }
        if (other.getHttpHeaders() == null ^ this.getHttpHeaders() == null) {
            return false;
        }
        if (other.getHttpHeaders() != null && !other.getHttpHeaders().equals(this.getHttpHeaders())) {
            return false;
        }
        if (other.getEncodedData() == null ^ this.getEncodedData() == null) {
            return false;
        }
        return other.getEncodedData() == null || other.getEncodedData().equals(this.getEncodedData());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIpAddress() == null ? 0 : this.getIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getServerName() == null ? 0 : this.getServerName().hashCode());
        hashCode = 31 * hashCode + (this.getServerPath() == null ? 0 : this.getServerPath().hashCode());
        hashCode = 31 * hashCode + (this.getHttpHeaders() == null ? 0 : this.getHttpHeaders().hashCode());
        hashCode = 31 * hashCode + (this.getEncodedData() == null ? 0 : this.getEncodedData().hashCode());
        return hashCode;
    }

    public ContextDataType clone() {
        try {
            return (ContextDataType)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContextDataTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

