/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.connect.model.Application;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateSecurityProfileRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String securityProfileName;
    private String description;
    private List<String> permissions;
    private String instanceId;
    private Map<String, String> tags;
    private Map<String, String> allowedAccessControlTags;
    private List<String> tagRestrictedResources;
    private List<Application> applications;

    public void setSecurityProfileName(String securityProfileName) {
        this.securityProfileName = securityProfileName;
    }

    public String getSecurityProfileName() {
        return this.securityProfileName;
    }

    public CreateSecurityProfileRequest withSecurityProfileName(String securityProfileName) {
        this.setSecurityProfileName(securityProfileName);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateSecurityProfileRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Collection<String> permissions) {
        if (permissions == null) {
            this.permissions = null;
            return;
        }
        this.permissions = new ArrayList<String>(permissions);
    }

    public CreateSecurityProfileRequest withPermissions(String ... permissions) {
        if (this.permissions == null) {
            this.setPermissions(new ArrayList<String>(permissions.length));
        }
        for (String ele : permissions) {
            this.permissions.add(ele);
        }
        return this;
    }

    public CreateSecurityProfileRequest withPermissions(Collection<String> permissions) {
        this.setPermissions(permissions);
        return this;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public CreateSecurityProfileRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateSecurityProfileRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateSecurityProfileRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateSecurityProfileRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public Map<String, String> getAllowedAccessControlTags() {
        return this.allowedAccessControlTags;
    }

    public void setAllowedAccessControlTags(Map<String, String> allowedAccessControlTags) {
        this.allowedAccessControlTags = allowedAccessControlTags;
    }

    public CreateSecurityProfileRequest withAllowedAccessControlTags(Map<String, String> allowedAccessControlTags) {
        this.setAllowedAccessControlTags(allowedAccessControlTags);
        return this;
    }

    public CreateSecurityProfileRequest addAllowedAccessControlTagsEntry(String key, String value) {
        if (null == this.allowedAccessControlTags) {
            this.allowedAccessControlTags = new HashMap<String, String>();
        }
        if (this.allowedAccessControlTags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.allowedAccessControlTags.put(key, value);
        return this;
    }

    public CreateSecurityProfileRequest clearAllowedAccessControlTagsEntries() {
        this.allowedAccessControlTags = null;
        return this;
    }

    public List<String> getTagRestrictedResources() {
        return this.tagRestrictedResources;
    }

    public void setTagRestrictedResources(Collection<String> tagRestrictedResources) {
        if (tagRestrictedResources == null) {
            this.tagRestrictedResources = null;
            return;
        }
        this.tagRestrictedResources = new ArrayList<String>(tagRestrictedResources);
    }

    public CreateSecurityProfileRequest withTagRestrictedResources(String ... tagRestrictedResources) {
        if (this.tagRestrictedResources == null) {
            this.setTagRestrictedResources(new ArrayList<String>(tagRestrictedResources.length));
        }
        for (String ele : tagRestrictedResources) {
            this.tagRestrictedResources.add(ele);
        }
        return this;
    }

    public CreateSecurityProfileRequest withTagRestrictedResources(Collection<String> tagRestrictedResources) {
        this.setTagRestrictedResources(tagRestrictedResources);
        return this;
    }

    public List<Application> getApplications() {
        return this.applications;
    }

    public void setApplications(Collection<Application> applications) {
        if (applications == null) {
            this.applications = null;
            return;
        }
        this.applications = new ArrayList<Application>(applications);
    }

    public CreateSecurityProfileRequest withApplications(Application ... applications) {
        if (this.applications == null) {
            this.setApplications(new ArrayList<Application>(applications.length));
        }
        for (Application ele : applications) {
            this.applications.add(ele);
        }
        return this;
    }

    public CreateSecurityProfileRequest withApplications(Collection<Application> applications) {
        this.setApplications(applications);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSecurityProfileName() != null) {
            sb.append("SecurityProfileName: ").append(this.getSecurityProfileName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getPermissions() != null) {
            sb.append("Permissions: ").append(this.getPermissions()).append(",");
        }
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getAllowedAccessControlTags() != null) {
            sb.append("AllowedAccessControlTags: ").append(this.getAllowedAccessControlTags()).append(",");
        }
        if (this.getTagRestrictedResources() != null) {
            sb.append("TagRestrictedResources: ").append(this.getTagRestrictedResources()).append(",");
        }
        if (this.getApplications() != null) {
            sb.append("Applications: ").append(this.getApplications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSecurityProfileRequest)) {
            return false;
        }
        CreateSecurityProfileRequest other = (CreateSecurityProfileRequest)obj;
        if (other.getSecurityProfileName() == null ^ this.getSecurityProfileName() == null) {
            return false;
        }
        if (other.getSecurityProfileName() != null && !other.getSecurityProfileName().equals(this.getSecurityProfileName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getPermissions() == null ^ this.getPermissions() == null) {
            return false;
        }
        if (other.getPermissions() != null && !other.getPermissions().equals(this.getPermissions())) {
            return false;
        }
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getAllowedAccessControlTags() == null ^ this.getAllowedAccessControlTags() == null) {
            return false;
        }
        if (other.getAllowedAccessControlTags() != null && !other.getAllowedAccessControlTags().equals(this.getAllowedAccessControlTags())) {
            return false;
        }
        if (other.getTagRestrictedResources() == null ^ this.getTagRestrictedResources() == null) {
            return false;
        }
        if (other.getTagRestrictedResources() != null && !other.getTagRestrictedResources().equals(this.getTagRestrictedResources())) {
            return false;
        }
        if (other.getApplications() == null ^ this.getApplications() == null) {
            return false;
        }
        return other.getApplications() == null || other.getApplications().equals(this.getApplications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSecurityProfileName() == null ? 0 : this.getSecurityProfileName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getPermissions() == null ? 0 : this.getPermissions().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getAllowedAccessControlTags() == null ? 0 : this.getAllowedAccessControlTags().hashCode());
        hashCode = 31 * hashCode + (this.getTagRestrictedResources() == null ? 0 : this.getTagRestrictedResources().hashCode());
        hashCode = 31 * hashCode + (this.getApplications() == null ? 0 : this.getApplications().hashCode());
        return hashCode;
    }

    public CreateSecurityProfileRequest clone() {
        return (CreateSecurityProfileRequest)super.clone();
    }
}

