/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datazone.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PutEnvironmentBlueprintConfigurationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String domainIdentifier;
    private List<String> enabledRegions;
    private String environmentBlueprintIdentifier;
    private String manageAccessRoleArn;
    private String provisioningRoleArn;
    private Map<String, Map<String, String>> regionalParameters;

    public void setDomainIdentifier(String domainIdentifier) {
        this.domainIdentifier = domainIdentifier;
    }

    public String getDomainIdentifier() {
        return this.domainIdentifier;
    }

    public PutEnvironmentBlueprintConfigurationRequest withDomainIdentifier(String domainIdentifier) {
        this.setDomainIdentifier(domainIdentifier);
        return this;
    }

    public List<String> getEnabledRegions() {
        return this.enabledRegions;
    }

    public void setEnabledRegions(Collection<String> enabledRegions) {
        if (enabledRegions == null) {
            this.enabledRegions = null;
            return;
        }
        this.enabledRegions = new ArrayList<String>(enabledRegions);
    }

    public PutEnvironmentBlueprintConfigurationRequest withEnabledRegions(String ... enabledRegions) {
        if (this.enabledRegions == null) {
            this.setEnabledRegions(new ArrayList<String>(enabledRegions.length));
        }
        for (String ele : enabledRegions) {
            this.enabledRegions.add(ele);
        }
        return this;
    }

    public PutEnvironmentBlueprintConfigurationRequest withEnabledRegions(Collection<String> enabledRegions) {
        this.setEnabledRegions(enabledRegions);
        return this;
    }

    public void setEnvironmentBlueprintIdentifier(String environmentBlueprintIdentifier) {
        this.environmentBlueprintIdentifier = environmentBlueprintIdentifier;
    }

    public String getEnvironmentBlueprintIdentifier() {
        return this.environmentBlueprintIdentifier;
    }

    public PutEnvironmentBlueprintConfigurationRequest withEnvironmentBlueprintIdentifier(String environmentBlueprintIdentifier) {
        this.setEnvironmentBlueprintIdentifier(environmentBlueprintIdentifier);
        return this;
    }

    public void setManageAccessRoleArn(String manageAccessRoleArn) {
        this.manageAccessRoleArn = manageAccessRoleArn;
    }

    public String getManageAccessRoleArn() {
        return this.manageAccessRoleArn;
    }

    public PutEnvironmentBlueprintConfigurationRequest withManageAccessRoleArn(String manageAccessRoleArn) {
        this.setManageAccessRoleArn(manageAccessRoleArn);
        return this;
    }

    public void setProvisioningRoleArn(String provisioningRoleArn) {
        this.provisioningRoleArn = provisioningRoleArn;
    }

    public String getProvisioningRoleArn() {
        return this.provisioningRoleArn;
    }

    public PutEnvironmentBlueprintConfigurationRequest withProvisioningRoleArn(String provisioningRoleArn) {
        this.setProvisioningRoleArn(provisioningRoleArn);
        return this;
    }

    public Map<String, Map<String, String>> getRegionalParameters() {
        return this.regionalParameters;
    }

    public void setRegionalParameters(Map<String, Map<String, String>> regionalParameters) {
        this.regionalParameters = regionalParameters;
    }

    public PutEnvironmentBlueprintConfigurationRequest withRegionalParameters(Map<String, Map<String, String>> regionalParameters) {
        this.setRegionalParameters(regionalParameters);
        return this;
    }

    public PutEnvironmentBlueprintConfigurationRequest addRegionalParametersEntry(String key, Map<String, String> value) {
        if (null == this.regionalParameters) {
            this.regionalParameters = new HashMap<String, Map<String, String>>();
        }
        if (this.regionalParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.regionalParameters.put(key, value);
        return this;
    }

    public PutEnvironmentBlueprintConfigurationRequest clearRegionalParametersEntries() {
        this.regionalParameters = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomainIdentifier() != null) {
            sb.append("DomainIdentifier: ").append(this.getDomainIdentifier()).append(",");
        }
        if (this.getEnabledRegions() != null) {
            sb.append("EnabledRegions: ").append(this.getEnabledRegions()).append(",");
        }
        if (this.getEnvironmentBlueprintIdentifier() != null) {
            sb.append("EnvironmentBlueprintIdentifier: ").append(this.getEnvironmentBlueprintIdentifier()).append(",");
        }
        if (this.getManageAccessRoleArn() != null) {
            sb.append("ManageAccessRoleArn: ").append(this.getManageAccessRoleArn()).append(",");
        }
        if (this.getProvisioningRoleArn() != null) {
            sb.append("ProvisioningRoleArn: ").append(this.getProvisioningRoleArn()).append(",");
        }
        if (this.getRegionalParameters() != null) {
            sb.append("RegionalParameters: ").append(this.getRegionalParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEnvironmentBlueprintConfigurationRequest)) {
            return false;
        }
        PutEnvironmentBlueprintConfigurationRequest other = (PutEnvironmentBlueprintConfigurationRequest)obj;
        if (other.getDomainIdentifier() == null ^ this.getDomainIdentifier() == null) {
            return false;
        }
        if (other.getDomainIdentifier() != null && !other.getDomainIdentifier().equals(this.getDomainIdentifier())) {
            return false;
        }
        if (other.getEnabledRegions() == null ^ this.getEnabledRegions() == null) {
            return false;
        }
        if (other.getEnabledRegions() != null && !other.getEnabledRegions().equals(this.getEnabledRegions())) {
            return false;
        }
        if (other.getEnvironmentBlueprintIdentifier() == null ^ this.getEnvironmentBlueprintIdentifier() == null) {
            return false;
        }
        if (other.getEnvironmentBlueprintIdentifier() != null && !other.getEnvironmentBlueprintIdentifier().equals(this.getEnvironmentBlueprintIdentifier())) {
            return false;
        }
        if (other.getManageAccessRoleArn() == null ^ this.getManageAccessRoleArn() == null) {
            return false;
        }
        if (other.getManageAccessRoleArn() != null && !other.getManageAccessRoleArn().equals(this.getManageAccessRoleArn())) {
            return false;
        }
        if (other.getProvisioningRoleArn() == null ^ this.getProvisioningRoleArn() == null) {
            return false;
        }
        if (other.getProvisioningRoleArn() != null && !other.getProvisioningRoleArn().equals(this.getProvisioningRoleArn())) {
            return false;
        }
        if (other.getRegionalParameters() == null ^ this.getRegionalParameters() == null) {
            return false;
        }
        return other.getRegionalParameters() == null || other.getRegionalParameters().equals(this.getRegionalParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomainIdentifier() == null ? 0 : this.getDomainIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getEnabledRegions() == null ? 0 : this.getEnabledRegions().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentBlueprintIdentifier() == null ? 0 : this.getEnvironmentBlueprintIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getManageAccessRoleArn() == null ? 0 : this.getManageAccessRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getProvisioningRoleArn() == null ? 0 : this.getProvisioningRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getRegionalParameters() == null ? 0 : this.getRegionalParameters().hashCode());
        return hashCode;
    }

    public PutEnvironmentBlueprintConfigurationRequest clone() {
        return (PutEnvironmentBlueprintConfigurationRequest)super.clone();
    }
}

