/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datazone.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.datazone.model.ConfigurableActionParameter;
import com.amazonaws.services.datazone.model.ConfigurableActionTypeAuthorization;
import com.amazonaws.services.datazone.model.transform.ConfigurableEnvironmentActionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ConfigurableEnvironmentAction
implements Serializable,
Cloneable,
StructuredPojo {
    private String auth;
    private List<ConfigurableActionParameter> parameters;
    private String type;

    public void setAuth(String auth) {
        this.auth = auth;
    }

    public String getAuth() {
        return this.auth;
    }

    public ConfigurableEnvironmentAction withAuth(String auth) {
        this.setAuth(auth);
        return this;
    }

    public ConfigurableEnvironmentAction withAuth(ConfigurableActionTypeAuthorization auth) {
        this.auth = auth.toString();
        return this;
    }

    public List<ConfigurableActionParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(Collection<ConfigurableActionParameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        this.parameters = new ArrayList<ConfigurableActionParameter>(parameters);
    }

    public ConfigurableEnvironmentAction withParameters(ConfigurableActionParameter ... parameters) {
        if (this.parameters == null) {
            this.setParameters(new ArrayList<ConfigurableActionParameter>(parameters.length));
        }
        for (ConfigurableActionParameter ele : parameters) {
            this.parameters.add(ele);
        }
        return this;
    }

    public ConfigurableEnvironmentAction withParameters(Collection<ConfigurableActionParameter> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public ConfigurableEnvironmentAction withType(String type) {
        this.setType(type);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAuth() != null) {
            sb.append("Auth: ").append(this.getAuth()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurableEnvironmentAction)) {
            return false;
        }
        ConfigurableEnvironmentAction other = (ConfigurableEnvironmentAction)obj;
        if (other.getAuth() == null ^ this.getAuth() == null) {
            return false;
        }
        if (other.getAuth() != null && !other.getAuth().equals(this.getAuth())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAuth() == null ? 0 : this.getAuth().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    public ConfigurableEnvironmentAction clone() {
        try {
            return (ConfigurableEnvironmentAction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigurableEnvironmentActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

