/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticmapreduce.model.ScalingAction;
import com.amazonaws.services.elasticmapreduce.model.transform.SimpleScalingPolicyConfigurationJsonMarshaller;

public class ScalingActionJsonMarshaller {
    private static ScalingActionJsonMarshaller instance;

    public void marshall(ScalingAction scalingAction, StructuredJsonGenerator jsonGenerator) {
        if (scalingAction == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (scalingAction.getMarket() != null) {
                jsonGenerator.writeFieldName("Market").writeValue(scalingAction.getMarket());
            }
            if (scalingAction.getSimpleScalingPolicyConfiguration() != null) {
                jsonGenerator.writeFieldName("SimpleScalingPolicyConfiguration");
                SimpleScalingPolicyConfigurationJsonMarshaller.getInstance().marshall(scalingAction.getSimpleScalingPolicyConfiguration(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ScalingActionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ScalingActionJsonMarshaller();
        }
        return instance;
    }
}

