/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.DescribePlayerSessionsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribePlayerSessionsRequestMarshaller
implements Marshaller<Request<DescribePlayerSessionsRequest>, DescribePlayerSessionsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DescribePlayerSessionsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribePlayerSessionsRequest> marshall(DescribePlayerSessionsRequest describePlayerSessionsRequest) {
        if (describePlayerSessionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describePlayerSessionsRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.DescribePlayerSessions");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describePlayerSessionsRequest.getGameSessionId() != null) {
                jsonGenerator.writeFieldName("GameSessionId").writeValue(describePlayerSessionsRequest.getGameSessionId());
            }
            if (describePlayerSessionsRequest.getPlayerId() != null) {
                jsonGenerator.writeFieldName("PlayerId").writeValue(describePlayerSessionsRequest.getPlayerId());
            }
            if (describePlayerSessionsRequest.getPlayerSessionId() != null) {
                jsonGenerator.writeFieldName("PlayerSessionId").writeValue(describePlayerSessionsRequest.getPlayerSessionId());
            }
            if (describePlayerSessionsRequest.getPlayerSessionStatusFilter() != null) {
                jsonGenerator.writeFieldName("PlayerSessionStatusFilter").writeValue(describePlayerSessionsRequest.getPlayerSessionStatusFilter());
            }
            if (describePlayerSessionsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(describePlayerSessionsRequest.getLimit().intValue());
            }
            if (describePlayerSessionsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describePlayerSessionsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

