/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.inspector2.model.Runtime;
import com.amazonaws.services.inspector2.model.transform.LambdaFunctionMetadataMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LambdaFunctionMetadata
implements Serializable,
Cloneable,
StructuredPojo {
    private String functionName;
    private Map<String, String> functionTags;
    private List<String> layers;
    private String runtime;

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public LambdaFunctionMetadata withFunctionName(String functionName) {
        this.setFunctionName(functionName);
        return this;
    }

    public Map<String, String> getFunctionTags() {
        return this.functionTags;
    }

    public void setFunctionTags(Map<String, String> functionTags) {
        this.functionTags = functionTags;
    }

    public LambdaFunctionMetadata withFunctionTags(Map<String, String> functionTags) {
        this.setFunctionTags(functionTags);
        return this;
    }

    public LambdaFunctionMetadata addFunctionTagsEntry(String key, String value) {
        if (null == this.functionTags) {
            this.functionTags = new HashMap<String, String>();
        }
        if (this.functionTags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.functionTags.put(key, value);
        return this;
    }

    public LambdaFunctionMetadata clearFunctionTagsEntries() {
        this.functionTags = null;
        return this;
    }

    public List<String> getLayers() {
        return this.layers;
    }

    public void setLayers(Collection<String> layers) {
        if (layers == null) {
            this.layers = null;
            return;
        }
        this.layers = new ArrayList<String>(layers);
    }

    public LambdaFunctionMetadata withLayers(String ... layers) {
        if (this.layers == null) {
            this.setLayers(new ArrayList<String>(layers.length));
        }
        for (String ele : layers) {
            this.layers.add(ele);
        }
        return this;
    }

    public LambdaFunctionMetadata withLayers(Collection<String> layers) {
        this.setLayers(layers);
        return this;
    }

    public void setRuntime(String runtime) {
        this.runtime = runtime;
    }

    public String getRuntime() {
        return this.runtime;
    }

    public LambdaFunctionMetadata withRuntime(String runtime) {
        this.setRuntime(runtime);
        return this;
    }

    public LambdaFunctionMetadata withRuntime(Runtime runtime) {
        this.runtime = runtime.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFunctionName() != null) {
            sb.append("FunctionName: ").append(this.getFunctionName()).append(",");
        }
        if (this.getFunctionTags() != null) {
            sb.append("FunctionTags: ").append(this.getFunctionTags()).append(",");
        }
        if (this.getLayers() != null) {
            sb.append("Layers: ").append(this.getLayers()).append(",");
        }
        if (this.getRuntime() != null) {
            sb.append("Runtime: ").append(this.getRuntime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionMetadata)) {
            return false;
        }
        LambdaFunctionMetadata other = (LambdaFunctionMetadata)obj;
        if (other.getFunctionName() == null ^ this.getFunctionName() == null) {
            return false;
        }
        if (other.getFunctionName() != null && !other.getFunctionName().equals(this.getFunctionName())) {
            return false;
        }
        if (other.getFunctionTags() == null ^ this.getFunctionTags() == null) {
            return false;
        }
        if (other.getFunctionTags() != null && !other.getFunctionTags().equals(this.getFunctionTags())) {
            return false;
        }
        if (other.getLayers() == null ^ this.getLayers() == null) {
            return false;
        }
        if (other.getLayers() != null && !other.getLayers().equals(this.getLayers())) {
            return false;
        }
        if (other.getRuntime() == null ^ this.getRuntime() == null) {
            return false;
        }
        return other.getRuntime() == null || other.getRuntime().equals(this.getRuntime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFunctionName() == null ? 0 : this.getFunctionName().hashCode());
        hashCode = 31 * hashCode + (this.getFunctionTags() == null ? 0 : this.getFunctionTags().hashCode());
        hashCode = 31 * hashCode + (this.getLayers() == null ? 0 : this.getLayers().hashCode());
        hashCode = 31 * hashCode + (this.getRuntime() == null ? 0 : this.getRuntime().hashCode());
        return hashCode;
    }

    public LambdaFunctionMetadata clone() {
        try {
            return (LambdaFunctionMetadata)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LambdaFunctionMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

