/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediapackage.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediapackage.model.HlsIngest;
import com.amazonaws.services.mediapackage.model.transform.ChannelMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Channel
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private String description;
    private HlsIngest hlsIngest;
    private String id;
    private Map<String, String> tags;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Channel withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Channel withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setHlsIngest(HlsIngest hlsIngest) {
        this.hlsIngest = hlsIngest;
    }

    public HlsIngest getHlsIngest() {
        return this.hlsIngest;
    }

    public Channel withHlsIngest(HlsIngest hlsIngest) {
        this.setHlsIngest(hlsIngest);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Channel withId(String id) {
        this.setId(id);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Channel withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Channel addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Channel clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getHlsIngest() != null) {
            sb.append("HlsIngest: ").append(this.getHlsIngest()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Channel)) {
            return false;
        }
        Channel other = (Channel)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getHlsIngest() == null ^ this.getHlsIngest() == null) {
            return false;
        }
        if (other.getHlsIngest() != null && !other.getHlsIngest().equals(this.getHlsIngest())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getHlsIngest() == null ? 0 : this.getHlsIngest().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public Channel clone() {
        try {
            return (Channel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ChannelMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

