/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.stepfunctions.model.HistoryEvent;
import java.util.Date;

@SdkInternalApi
public class HistoryEventMarshaller {
    private static final MarshallingInfo<Date> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timestamp").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MarshallingInfo<Long> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<Long> PREVIOUSEVENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("previousEventId").build();
    private static final MarshallingInfo<StructuredPojo> ACTIVITYFAILEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activityFailedEventDetails").build();
    private static final MarshallingInfo<StructuredPojo> ACTIVITYSCHEDULEFAILEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activityScheduleFailedEventDetails").build();
    private static final MarshallingInfo<StructuredPojo> ACTIVITYSCHEDULEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activityScheduledEventDetails").build();
    private static final MarshallingInfo<StructuredPojo> ACTIVITYSTARTEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activityStartedEventDetails").build();
    private static final MarshallingInfo<StructuredPojo> ACTIVITYSUCCEEDEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activitySucceededEventDetails").build();
    private static final MarshallingInfo<StructuredPojo> ACTIVITYTIMEDOUTEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activityTimedOutEventDetails").build();
    private static final MarshallingInfo<StructuredPojo> EXECUTIONFAILEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("executionFailedEventDetails").build();
    private static final MarshallingInfo<StructuredPojo> EXECUTIONSTARTEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("executionStartedEventDetails").build();
    private static final MarshallingInfo<StructuredPojo> EXECUTIONSUCCEEDEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("executionSucceededEventDetails").build();
    private static final MarshallingInfo<StructuredPojo> EXECUTIONABORTEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("executionAbortedEventDetails").build();
    private static final MarshallingInfo<StructuredPojo> EXECUTIONTIMEDOUTEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("executionTimedOutEventDetails").build();
    private static final MarshallingInfo<StructuredPojo> LAMBDAFUNCTIONFAILEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lambdaFunctionFailedEventDetails").build();
    private static final MarshallingInfo<StructuredPojo> LAMBDAFUNCTIONSCHEDULEFAILEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lambdaFunctionScheduleFailedEventDetails").build();
    private static final MarshallingInfo<StructuredPojo> LAMBDAFUNCTIONSCHEDULEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lambdaFunctionScheduledEventDetails").build();
    private static final MarshallingInfo<StructuredPojo> LAMBDAFUNCTIONSTARTFAILEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lambdaFunctionStartFailedEventDetails").build();
    private static final MarshallingInfo<StructuredPojo> LAMBDAFUNCTIONSUCCEEDEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lambdaFunctionSucceededEventDetails").build();
    private static final MarshallingInfo<StructuredPojo> LAMBDAFUNCTIONTIMEDOUTEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lambdaFunctionTimedOutEventDetails").build();
    private static final MarshallingInfo<StructuredPojo> STATEENTEREDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stateEnteredEventDetails").build();
    private static final MarshallingInfo<StructuredPojo> STATEEXITEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stateExitedEventDetails").build();
    private static final HistoryEventMarshaller instance = new HistoryEventMarshaller();

    public static HistoryEventMarshaller getInstance() {
        return instance;
    }

    public void marshall(HistoryEvent historyEvent, ProtocolMarshaller protocolMarshaller) {
        if (historyEvent == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)historyEvent.getTimestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.getType(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.getPreviousEventId(), PREVIOUSEVENTID_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.getActivityFailedEventDetails(), ACTIVITYFAILEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.getActivityScheduleFailedEventDetails(), ACTIVITYSCHEDULEFAILEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.getActivityScheduledEventDetails(), ACTIVITYSCHEDULEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.getActivityStartedEventDetails(), ACTIVITYSTARTEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.getActivitySucceededEventDetails(), ACTIVITYSUCCEEDEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.getActivityTimedOutEventDetails(), ACTIVITYTIMEDOUTEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.getExecutionFailedEventDetails(), EXECUTIONFAILEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.getExecutionStartedEventDetails(), EXECUTIONSTARTEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.getExecutionSucceededEventDetails(), EXECUTIONSUCCEEDEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.getExecutionAbortedEventDetails(), EXECUTIONABORTEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.getExecutionTimedOutEventDetails(), EXECUTIONTIMEDOUTEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.getLambdaFunctionFailedEventDetails(), LAMBDAFUNCTIONFAILEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.getLambdaFunctionScheduleFailedEventDetails(), LAMBDAFUNCTIONSCHEDULEFAILEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.getLambdaFunctionScheduledEventDetails(), LAMBDAFUNCTIONSCHEDULEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.getLambdaFunctionStartFailedEventDetails(), LAMBDAFUNCTIONSTARTFAILEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.getLambdaFunctionSucceededEventDetails(), LAMBDAFUNCTIONSUCCEEDEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.getLambdaFunctionTimedOutEventDetails(), LAMBDAFUNCTIONTIMEDOUTEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.getStateEnteredEventDetails(), STATEENTEREDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.getStateExitedEventDetails(), STATEEXITEDEVENTDETAILS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

